@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetIpAllocationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property ipAllocationName The name of the IpAllocation.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetIpAllocationPlainArgs(
    public val expand: String? = null,
    public val ipAllocationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetIpAllocationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetIpAllocationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetIpAllocationPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .ipAllocationName(ipAllocationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpAllocationPlainArgs].
 */
@PulumiTagMarker
public class GetIpAllocationPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var ipAllocationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("qpgkyvanagicvxls")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the IpAllocation.
     */
    @JvmName("ptekxrsoxntrkeyy")
    public suspend fun ipAllocationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipAllocationName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iuggfwyncghjshgr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIpAllocationPlainArgs = GetIpAllocationPlainArgs(
        expand = expand,
        ipAllocationName = ipAllocationName ?: throw PulumiNullFieldException("ipAllocationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
