@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkVirtualAppliancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property networkVirtualApplianceName The name of Network Virtual Appliance.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkVirtualAppliancePlainArgs(
    public val expand: String? = null,
    public val networkVirtualApplianceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkVirtualAppliancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkVirtualAppliancePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkVirtualAppliancePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .networkVirtualApplianceName(networkVirtualApplianceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkVirtualAppliancePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkVirtualAppliancePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var networkVirtualApplianceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("ghshvjygkfdubxtg")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of Network Virtual Appliance.
     */
    @JvmName("soidccmmmtgxvtjg")
    public suspend fun networkVirtualApplianceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkVirtualApplianceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mglkwhsinsgabhud")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkVirtualAppliancePlainArgs = GetNetworkVirtualAppliancePlainArgs(
        expand = expand,
        networkVirtualApplianceName = networkVirtualApplianceName ?: throw
            PulumiNullFieldException("networkVirtualApplianceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
