@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetOutboundEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsResolverName The name of the DNS resolver.
 * @property outboundEndpointName The name of the outbound endpoint for the DNS resolver.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetOutboundEndpointPlainArgs(
    public val dnsResolverName: String,
    public val outboundEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetOutboundEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetOutboundEndpointPlainArgs =
        com.pulumi.azurenative.network.inputs.GetOutboundEndpointPlainArgs.builder()
            .dnsResolverName(dnsResolverName.let({ args0 -> args0 }))
            .outboundEndpointName(outboundEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOutboundEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetOutboundEndpointPlainArgsBuilder internal constructor() {
    private var dnsResolverName: String? = null

    private var outboundEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("nrkdtfpxesrmumee")
    public suspend fun dnsResolverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The name of the outbound endpoint for the DNS resolver.
     */
    @JvmName("ysfprsocytjmhaiu")
    public suspend fun outboundEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.outboundEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mepfkmbeulmvfsdy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetOutboundEndpointPlainArgs = GetOutboundEndpointPlainArgs(
        dnsResolverName = dnsResolverName ?: throw PulumiNullFieldException("dnsResolverName"),
        outboundEndpointName = outboundEndpointName ?: throw
            PulumiNullFieldException("outboundEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
