@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the P2SVpnGateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs(
    public val gatewayName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs =
        com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs].
 */
@PulumiTagMarker
public class GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the P2SVpnGateway.
     */
    @JvmName("hlsvjwnahivimlmm")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nohofevktmsflyib")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs =
        GetP2sVpnGatewayP2sVpnConnectionHealthPlainArgs(
            gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
