@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the gateway.
 * @property resourceGroupName The resource group name of the P2SVpnGateway.
 */
public data class GetP2sVpnGatewayPlainArgs(
    public val gatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetP2sVpnGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetP2sVpnGatewayPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the gateway.
     */
    @JvmName("qybkqjoovlcbrdnc")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The resource group name of the P2SVpnGateway.
     */
    @JvmName("ynwmtqfjnpbuuevp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetP2sVpnGatewayPlainArgs = GetP2sVpnGatewayPlainArgs(
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
