@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetP2sVpnServerConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property p2SVpnServerConfigurationName The name of the P2SVpnServerConfiguration.
 * @property resourceGroupName The resource group name of the P2SVpnServerConfiguration.
 * @property virtualWanName The name of the VirtualWan.
 */
public data class GetP2sVpnServerConfigurationPlainArgs(
    public val p2SVpnServerConfigurationName: String,
    public val resourceGroupName: String,
    public val virtualWanName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetP2sVpnServerConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetP2sVpnServerConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetP2sVpnServerConfigurationPlainArgs.builder()
            .p2SVpnServerConfigurationName(p2SVpnServerConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualWanName(virtualWanName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetP2sVpnServerConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetP2sVpnServerConfigurationPlainArgsBuilder internal constructor() {
    private var p2SVpnServerConfigurationName: String? = null

    private var resourceGroupName: String? = null

    private var virtualWanName: String? = null

    /**
     * @param value The name of the P2SVpnServerConfiguration.
     */
    @JvmName("ihcqghfwlsdrjrpk")
    public suspend fun p2SVpnServerConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.p2SVpnServerConfigurationName = mapped
    }

    /**
     * @param value The resource group name of the P2SVpnServerConfiguration.
     */
    @JvmName("njfrwghvekfxtibg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualWan.
     */
    @JvmName("tfhbgcfifgywrpmp")
    public suspend fun virtualWanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualWanName = mapped
    }

    internal fun build(): GetP2sVpnServerConfigurationPlainArgs =
        GetP2sVpnServerConfigurationPlainArgs(
            p2SVpnServerConfigurationName = p2SVpnServerConfigurationName ?: throw
                PulumiNullFieldException("p2SVpnServerConfigurationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualWanName = virtualWanName ?: throw PulumiNullFieldException("virtualWanName"),
        )
}
