@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateDnsZoneGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateDnsZoneGroupName The name of the private dns zone group.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrivateDnsZoneGroupPlainArgs(
    public val privateDnsZoneGroupName: String,
    public val privateEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateDnsZoneGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPrivateDnsZoneGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateDnsZoneGroupPlainArgs.builder()
            .privateDnsZoneGroupName(privateDnsZoneGroupName.let({ args0 -> args0 }))
            .privateEndpointName(privateEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateDnsZoneGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateDnsZoneGroupPlainArgsBuilder internal constructor() {
    private var privateDnsZoneGroupName: String? = null

    private var privateEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the private dns zone group.
     */
    @JvmName("hcmgfixuvllvshrl")
    public suspend fun privateDnsZoneGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateDnsZoneGroupName = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("qqktdfmbdvtunnil")
    public suspend fun privateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yphhleuvsfcqpvdb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateDnsZoneGroupPlainArgs = GetPrivateDnsZoneGroupPlainArgs(
        privateDnsZoneGroupName = privateDnsZoneGroupName ?: throw
            PulumiNullFieldException("privateDnsZoneGroupName"),
        privateEndpointName = privateEndpointName ?: throw PulumiNullFieldException("privateEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
