@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrivateZonePlainArgs(
    public val privateZoneName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateZonePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPrivateZonePlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateZonePlainArgs.builder()
            .privateZoneName(privateZoneName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateZonePlainArgs].
 */
@PulumiTagMarker
public class GetPrivateZonePlainArgsBuilder internal constructor() {
    private var privateZoneName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("xejhaedkmyjeglei")
    public suspend fun privateZoneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateZoneName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("polieqascmrhjjbv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateZonePlainArgs = GetPrivateZonePlainArgs(
        privateZoneName = privateZoneName ?: throw PulumiNullFieldException("privateZoneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
