@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRecordSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property recordType The type of DNS record in this record set.
 * @property relativeRecordSetName The name of the record set, relative to the name of the zone.
 * @property resourceGroupName The name of the resource group.
 * @property zoneName The name of the DNS zone (without a terminating dot).
 */
public data class GetRecordSetPlainArgs(
    public val recordType: String,
    public val relativeRecordSetName: String,
    public val resourceGroupName: String,
    public val zoneName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRecordSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRecordSetPlainArgs =
        com.pulumi.azurenative.network.inputs.GetRecordSetPlainArgs.builder()
            .recordType(recordType.let({ args0 -> args0 }))
            .relativeRecordSetName(relativeRecordSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .zoneName(zoneName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRecordSetPlainArgs].
 */
@PulumiTagMarker
public class GetRecordSetPlainArgsBuilder internal constructor() {
    private var recordType: String? = null

    private var relativeRecordSetName: String? = null

    private var resourceGroupName: String? = null

    private var zoneName: String? = null

    /**
     * @param value The type of DNS record in this record set.
     */
    @JvmName("fuqruikigfuhqibm")
    public suspend fun recordType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.recordType = mapped
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("ejbdkwfkhbjwiivb")
    public suspend fun relativeRecordSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relativeRecordSetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gjasjknxaalylecy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("iopavpucprgcdxmm")
    public suspend fun zoneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneName = mapped
    }

    internal fun build(): GetRecordSetPlainArgs = GetRecordSetPlainArgs(
        recordType = recordType ?: throw PulumiNullFieldException("recordType"),
        relativeRecordSetName = relativeRecordSetName ?: throw
            PulumiNullFieldException("relativeRecordSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        zoneName = zoneName ?: throw PulumiNullFieldException("zoneName"),
    )
}
