@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRouteFilterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced express route bgp peering resources.
 * @property resourceGroupName The name of the resource group.
 * @property routeFilterName The name of the route filter.
 */
public data class GetRouteFilterPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val routeFilterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRouteFilterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRouteFilterPlainArgs =
        com.pulumi.azurenative.network.inputs.GetRouteFilterPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeFilterName(routeFilterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteFilterPlainArgs].
 */
@PulumiTagMarker
public class GetRouteFilterPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var routeFilterName: String? = null

    /**
     * @param value Expands referenced express route bgp peering resources.
     */
    @JvmName("hcppjnmpwfgvfkxt")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pwjtpvudfwfssxtn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("qbdtlultwggiegra")
    public suspend fun routeFilterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeFilterName = mapped
    }

    internal fun build(): GetRouteFilterPlainArgs = GetRouteFilterPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeFilterName = routeFilterName ?: throw PulumiNullFieldException("routeFilterName"),
    )
}
