@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSubnetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 * @property subnetName The name of the subnet.
 * @property virtualNetworkName The name of the virtual network.
 */
public data class GetSubnetPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val subnetName: String,
    public val virtualNetworkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSubnetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetSubnetPlainArgs =
        com.pulumi.azurenative.network.inputs.GetSubnetPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subnetName(subnetName.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubnetPlainArgs].
 */
@PulumiTagMarker
public class GetSubnetPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var subnetName: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("mopxhylqctgokwtq")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tousiavcelkgpips")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the subnet.
     */
    @JvmName("bdgskhnajubenlwe")
    public suspend fun subnetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subnetName = mapped
    }

    /**
     * @param value The name of the virtual network.
     */
    @JvmName("ghfwqdxrcgxskkqf")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): GetSubnetPlainArgs = GetSubnetPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subnetName = subnetName ?: throw PulumiNullFieldException("subnetName"),
        virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
    )
}
