@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualApplianceSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkVirtualApplianceName The name of the Network Virtual Appliance.
 * @property resourceGroupName The name of the resource group.
 * @property siteName The name of the site.
 */
public data class GetVirtualApplianceSitePlainArgs(
    public val networkVirtualApplianceName: String,
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualApplianceSitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualApplianceSitePlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualApplianceSitePlainArgs.builder()
            .networkVirtualApplianceName(networkVirtualApplianceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualApplianceSitePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualApplianceSitePlainArgsBuilder internal constructor() {
    private var networkVirtualApplianceName: String? = null

    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value The name of the Network Virtual Appliance.
     */
    @JvmName("egrbciuwuxdrabtq")
    public suspend fun networkVirtualApplianceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkVirtualApplianceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pifbcocywwnpgboe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the site.
     */
    @JvmName("ioykbxokeoediwob")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetVirtualApplianceSitePlainArgs = GetVirtualApplianceSitePlainArgs(
        networkVirtualApplianceName = networkVirtualApplianceName ?: throw
            PulumiNullFieldException("networkVirtualApplianceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
    )
}
