@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualHubBgpConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the connection.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class GetVirtualHubBgpConnectionPlainArgs(
    public val connectionName: String,
    public val resourceGroupName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualHubBgpConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualHubBgpConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualHubBgpConnectionPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualHubBgpConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualHubBgpConnectionPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var resourceGroupName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The name of the connection.
     */
    @JvmName("jhomaryythnbhoof")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("ghovgsfjvrsmyaqu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("xwxjvbwbhccohntd")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetVirtualHubBgpConnectionPlainArgs = GetVirtualHubBgpConnectionPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
    )
}
