@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualHubPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class GetVirtualHubPlainArgs(
    public val resourceGroupName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualHubPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualHubPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualHubPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualHubPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualHubPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("tiqwxruhicttyydh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("rgxopktxluyvhbtn")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetVirtualHubPlainArgs = GetVirtualHubPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
    )
}
