@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkTapPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property tapName The name of virtual network tap.
 */
public data class GetVirtualNetworkTapPlainArgs(
    public val resourceGroupName: String,
    public val tapName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkTapPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkTapPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkTapPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tapName(tapName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkTapPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkTapPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var tapName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("agnhdxgxqwfwjxro")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of virtual network tap.
     */
    @JvmName("piatmixducyvlhmi")
    public suspend fun tapName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tapName = mapped
    }

    internal fun build(): GetVirtualNetworkTapPlainArgs = GetVirtualNetworkTapPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tapName = tapName ?: throw PulumiNullFieldException("tapName"),
    )
}
