@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualWanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the VirtualWan.
 * @property virtualWANName The name of the VirtualWAN being retrieved.
 */
public data class GetVirtualWanPlainArgs(
    public val resourceGroupName: String,
    public val virtualWANName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualWanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualWanPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualWanPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualWANName(virtualWANName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualWanPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualWanPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualWANName: String? = null

    /**
     * @param value The resource group name of the VirtualWan.
     */
    @JvmName("kjenctrlmsfqoimx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualWAN being retrieved.
     */
    @JvmName("xyrhojwjairscbdh")
    public suspend fun virtualWANName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualWANName = mapped
    }

    internal fun build(): GetVirtualWanPlainArgs = GetVirtualWanPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualWANName = virtualWANName ?: throw PulumiNullFieldException("virtualWANName"),
    )
}
