@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVpnGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the gateway.
 * @property resourceGroupName The resource group name of the VpnGateway.
 */
public data class GetVpnGatewayPlainArgs(
    public val gatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVpnGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVpnGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVpnGatewayPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetVpnGatewayPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the gateway.
     */
    @JvmName("cgordwiakqpnxpqh")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("kxrrmcjolbqscrls")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetVpnGatewayPlainArgs = GetVpnGatewayPlainArgs(
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
