@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HeaderActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.HeaderActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An action that can manipulate an http header.
 * @property headerActionType Which type of manipulation to apply to the header.
 * @property headerName The name of the header this action will apply to.
 * @property value The value to update the given header name with. This value is not used if the actionType is Delete.
 */
public data class HeaderActionArgs(
    public val headerActionType: Output<Either<String, HeaderActionType>>,
    public val headerName: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HeaderActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HeaderActionArgs =
        com.pulumi.azurenative.network.inputs.HeaderActionArgs.builder()
            .headerActionType(
                headerActionType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .headerName(headerName.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HeaderActionArgs].
 */
@PulumiTagMarker
public class HeaderActionArgsBuilder internal constructor() {
    private var headerActionType: Output<Either<String, HeaderActionType>>? = null

    private var headerName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Which type of manipulation to apply to the header.
     */
    @JvmName("ranyrcfhveoaslxu")
    public suspend fun headerActionType(`value`: Output<Either<String, HeaderActionType>>) {
        this.headerActionType = value
    }

    /**
     * @param value The name of the header this action will apply to.
     */
    @JvmName("wkcchbndhrbintqr")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value The value to update the given header name with. This value is not used if the actionType is Delete.
     */
    @JvmName("tlqqsjlfisruestb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Which type of manipulation to apply to the header.
     */
    @JvmName("ntgevpfmtooxgjwq")
    public suspend fun headerActionType(`value`: Either<String, HeaderActionType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerActionType = mapped
    }

    /**
     * @param value Which type of manipulation to apply to the header.
     */
    @JvmName("fffqjkayphnbfuvi")
    public fun headerActionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HeaderActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerActionType = mapped
    }

    /**
     * @param value Which type of manipulation to apply to the header.
     */
    @JvmName("rpvxbdbqrrnoeiso")
    public fun headerActionType(`value`: HeaderActionType) {
        val toBeMapped = Either.ofRight<String, HeaderActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerActionType = mapped
    }

    /**
     * @param value The name of the header this action will apply to.
     */
    @JvmName("jbvystdgtyhldjci")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    /**
     * @param value The value to update the given header name with. This value is not used if the actionType is Delete.
     */
    @JvmName("pvukuvmphuwvtrfg")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HeaderActionArgs = HeaderActionArgs(
        headerActionType = headerActionType ?: throw PulumiNullFieldException("headerActionType"),
        headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        `value` = `value`,
    )
}
