@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.HubRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * RouteTable route.
 * @property destinationType The type of destinations (eg: CIDR, ResourceId, Service).
 * @property destinations List of all destinations.
 * @property name The name of the Route that is unique within a RouteTable. This name can be used to access this route.
 * @property nextHop NextHop resource ID.
 * @property nextHopType The type of next hop (eg: ResourceId).
 */
public data class HubRouteArgs(
    public val destinationType: Output<String>,
    public val destinations: Output<List<String>>,
    public val name: Output<String>,
    public val nextHop: Output<String>,
    public val nextHopType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.HubRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.HubRouteArgs =
        com.pulumi.azurenative.network.inputs.HubRouteArgs.builder()
            .destinationType(destinationType.applyValue({ args0 -> args0 }))
            .destinations(destinations.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .nextHop(nextHop.applyValue({ args0 -> args0 }))
            .nextHopType(nextHopType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HubRouteArgs].
 */
@PulumiTagMarker
public class HubRouteArgsBuilder internal constructor() {
    private var destinationType: Output<String>? = null

    private var destinations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var nextHop: Output<String>? = null

    private var nextHopType: Output<String>? = null

    /**
     * @param value The type of destinations (eg: CIDR, ResourceId, Service).
     */
    @JvmName("yuykdmfjyteffpuj")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value List of all destinations.
     */
    @JvmName("cqaxphghdarcgiph")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("nkakdurmfhutbmcd")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of all destinations.
     */
    @JvmName("kspvdppxtsshumof")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value The name of the Route that is unique within a RouteTable. This name can be used to access this route.
     */
    @JvmName("mbueubrvrifrsmxe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value NextHop resource ID.
     */
    @JvmName("cjyollgmxcycvpjr")
    public suspend fun nextHop(`value`: Output<String>) {
        this.nextHop = value
    }

    /**
     * @param value The type of next hop (eg: ResourceId).
     */
    @JvmName("vtsycvbvwypgnfvn")
    public suspend fun nextHopType(`value`: Output<String>) {
        this.nextHopType = value
    }

    /**
     * @param value The type of destinations (eg: CIDR, ResourceId, Service).
     */
    @JvmName("pmekjfycyhixircr")
    public suspend fun destinationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value List of all destinations.
     */
    @JvmName("mnumeuufkagprydm")
    public suspend fun destinations(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of all destinations.
     */
    @JvmName("jikfspubncducdyj")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value The name of the Route that is unique within a RouteTable. This name can be used to access this route.
     */
    @JvmName("wkvhtpyfnslxtbyg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value NextHop resource ID.
     */
    @JvmName("bfkxhpctjxsomrqi")
    public suspend fun nextHop(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHop = mapped
    }

    /**
     * @param value The type of next hop (eg: ResourceId).
     */
    @JvmName("gtdoumfseynftjkn")
    public suspend fun nextHopType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextHopType = mapped
    }

    internal fun build(): HubRouteArgs = HubRouteArgs(
        destinationType = destinationType ?: throw PulumiNullFieldException("destinationType"),
        destinations = destinations ?: throw PulumiNullFieldException("destinations"),
        name = name ?: throw PulumiNullFieldException("name"),
        nextHop = nextHop ?: throw PulumiNullFieldException("nextHop"),
        nextHopType = nextHopType ?: throw PulumiNullFieldException("nextHopType"),
    )
}
