@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.LoadBalancerBackendAddressArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.LoadBalancerBackendAddressAdminState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Load balancer backend addresses.
 * @property adminState A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
 * @property ipAddress IP Address belonging to the referenced virtual network.
 * @property loadBalancerFrontendIPConfiguration Reference to the frontend ip address configuration defined in regional loadbalancer.
 * @property name Name of the backend address.
 * @property subnet Reference to an existing subnet.
 * @property virtualNetwork Reference to an existing virtual network.
 */
public data class LoadBalancerBackendAddressArgs(
    public val adminState: Output<Either<String, LoadBalancerBackendAddressAdminState>>? = null,
    public val ipAddress: Output<String>? = null,
    public val loadBalancerFrontendIPConfiguration: Output<SubResourceArgs>? = null,
    public val name: Output<String>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.LoadBalancerBackendAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.LoadBalancerBackendAddressArgs =
        com.pulumi.azurenative.network.inputs.LoadBalancerBackendAddressArgs.builder()
            .adminState(
                adminState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .loadBalancerFrontendIPConfiguration(
                loadBalancerFrontendIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualNetwork(
                virtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerBackendAddressArgs].
 */
@PulumiTagMarker
public class LoadBalancerBackendAddressArgsBuilder internal constructor() {
    private var adminState: Output<Either<String, LoadBalancerBackendAddressAdminState>>? = null

    private var ipAddress: Output<String>? = null

    private var loadBalancerFrontendIPConfiguration: Output<SubResourceArgs>? = null

    private var name: Output<String>? = null

    private var subnet: Output<SubResourceArgs>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    /**
     * @param value A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
     */
    @JvmName("txkmpfpkbqjcryvw")
    public suspend
    fun adminState(`value`: Output<Either<String, LoadBalancerBackendAddressAdminState>>) {
        this.adminState = value
    }

    /**
     * @param value IP Address belonging to the referenced virtual network.
     */
    @JvmName("xlnpxbhbybkwqvdw")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value Reference to the frontend ip address configuration defined in regional loadbalancer.
     */
    @JvmName("uuoumfewraxugras")
    public suspend fun loadBalancerFrontendIPConfiguration(`value`: Output<SubResourceArgs>) {
        this.loadBalancerFrontendIPConfiguration = value
    }

    /**
     * @param value Name of the backend address.
     */
    @JvmName("urkqmitgjphtwbnn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to an existing subnet.
     */
    @JvmName("mvritofgglirfrmh")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Reference to an existing virtual network.
     */
    @JvmName("jrrbduqebrenlesm")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
     */
    @JvmName("nablnxmhafcdueor")
    public suspend fun adminState(`value`: Either<String, LoadBalancerBackendAddressAdminState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
     */
    @JvmName("aoqxjvqqlhteejql")
    public fun adminState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerBackendAddressAdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
     */
    @JvmName("kvfphkpcceabsrrj")
    public fun adminState(`value`: LoadBalancerBackendAddressAdminState) {
        val toBeMapped = Either.ofRight<String, LoadBalancerBackendAddressAdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value IP Address belonging to the referenced virtual network.
     */
    @JvmName("aoibetaidpfxogcq")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value Reference to the frontend ip address configuration defined in regional loadbalancer.
     */
    @JvmName("rxfokogueegkbcep")
    public suspend fun loadBalancerFrontendIPConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerFrontendIPConfiguration = mapped
    }

    /**
     * @param argument Reference to the frontend ip address configuration defined in regional loadbalancer.
     */
    @JvmName("xfwlvfxrkpmcspyc")
    public suspend
    fun loadBalancerFrontendIPConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerFrontendIPConfiguration = mapped
    }

    /**
     * @param value Name of the backend address.
     */
    @JvmName("juecnsagjyhpnyjy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to an existing subnet.
     */
    @JvmName("dhygllrnnxtsiwwm")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference to an existing subnet.
     */
    @JvmName("dukjfegwkllvjgqb")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Reference to an existing virtual network.
     */
    @JvmName("pogegmjeafxjxkve")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument Reference to an existing virtual network.
     */
    @JvmName("pwuwegckhobpkthu")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    internal fun build(): LoadBalancerBackendAddressArgs = LoadBalancerBackendAddressArgs(
        adminState = adminState,
        ipAddress = ipAddress,
        loadBalancerFrontendIPConfiguration = loadBalancerFrontendIPConfiguration,
        name = name,
        subnet = subnet,
        virtualNetwork = virtualNetwork,
    )
}
