@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ManagedRuleExclusionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ManagedRuleExclusionMatchVariable
import com.pulumi.azurenative.network.kotlin.enums.ManagedRuleExclusionSelectorMatchOperator
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Exclude variables from managed rule evaluation.
 * @property matchVariable The variable type to be excluded.
 * @property selector Selector value for which elements in the collection this exclusion applies to.
 * @property selectorMatchOperator Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
 */
public data class ManagedRuleExclusionArgs(
    public val matchVariable: Output<Either<String, ManagedRuleExclusionMatchVariable>>,
    public val selector: Output<String>,
    public val selectorMatchOperator:
    Output<Either<String, ManagedRuleExclusionSelectorMatchOperator>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ManagedRuleExclusionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ManagedRuleExclusionArgs =
        com.pulumi.azurenative.network.inputs.ManagedRuleExclusionArgs.builder()
            .matchVariable(
                matchVariable.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .selector(selector.applyValue({ args0 -> args0 }))
            .selectorMatchOperator(
                selectorMatchOperator.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ManagedRuleExclusionArgs].
 */
@PulumiTagMarker
public class ManagedRuleExclusionArgsBuilder internal constructor() {
    private var matchVariable: Output<Either<String, ManagedRuleExclusionMatchVariable>>? = null

    private var selector: Output<String>? = null

    private var selectorMatchOperator:
        Output<Either<String, ManagedRuleExclusionSelectorMatchOperator>>? = null

    /**
     * @param value The variable type to be excluded.
     */
    @JvmName("kcfspfgitnrniuxl")
    public suspend
    fun matchVariable(`value`: Output<Either<String, ManagedRuleExclusionMatchVariable>>) {
        this.matchVariable = value
    }

    /**
     * @param value Selector value for which elements in the collection this exclusion applies to.
     */
    @JvmName("ubukjudrlsmqawhk")
    public suspend fun selector(`value`: Output<String>) {
        this.selector = value
    }

    /**
     * @param value Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
     */
    @JvmName("lkimkoihnymlotol")
    public suspend
    fun selectorMatchOperator(`value`: Output<Either<String, ManagedRuleExclusionSelectorMatchOperator>>) {
        this.selectorMatchOperator = value
    }

    /**
     * @param value The variable type to be excluded.
     */
    @JvmName("yielphgckofkrimj")
    public suspend fun matchVariable(`value`: Either<String, ManagedRuleExclusionMatchVariable>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable type to be excluded.
     */
    @JvmName("gleiujqbsbpfqrhj")
    public fun matchVariable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleExclusionMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value The variable type to be excluded.
     */
    @JvmName("egutelbcjkodjtqa")
    public fun matchVariable(`value`: ManagedRuleExclusionMatchVariable) {
        val toBeMapped = Either.ofRight<String, ManagedRuleExclusionMatchVariable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariable = mapped
    }

    /**
     * @param value Selector value for which elements in the collection this exclusion applies to.
     */
    @JvmName("qnadmjygbsnbfiww")
    public suspend fun selector(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param value Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
     */
    @JvmName("vgkoomramxxxocgg")
    public suspend
    fun selectorMatchOperator(`value`: Either<String, ManagedRuleExclusionSelectorMatchOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
     */
    @JvmName("gekuopidbjdygrsp")
    public fun selectorMatchOperator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleExclusionSelectorMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    /**
     * @param value Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
     */
    @JvmName("ngpxaxtplpffcgda")
    public fun selectorMatchOperator(`value`: ManagedRuleExclusionSelectorMatchOperator) {
        val toBeMapped = Either.ofRight<String, ManagedRuleExclusionSelectorMatchOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectorMatchOperator = mapped
    }

    internal fun build(): ManagedRuleExclusionArgs = ManagedRuleExclusionArgs(
        matchVariable = matchVariable ?: throw PulumiNullFieldException("matchVariable"),
        selector = selector ?: throw PulumiNullFieldException("selector"),
        selectorMatchOperator = selectorMatchOperator ?: throw
            PulumiNullFieldException("selectorMatchOperator"),
    )
}
