@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.MatchConditionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallOperator
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallTransform
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define match conditions.
 * @property matchValues Match value.
 * @property matchVariables List of match variables.
 * @property negationConditon Whether this is negate condition or not.
 * @property operator The operator to be matched.
 * @property transforms List of transforms.
 */
public data class MatchConditionArgs(
    public val matchValues: Output<List<String>>,
    public val matchVariables: Output<List<MatchVariableArgs>>,
    public val negationConditon: Output<Boolean>? = null,
    public val `operator`: Output<Either<String, WebApplicationFirewallOperator>>,
    public val transforms: Output<List<Either<String, WebApplicationFirewallTransform>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.MatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.MatchConditionArgs =
        com.pulumi.azurenative.network.inputs.MatchConditionArgs.builder()
            .matchValues(matchValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchVariables(
                matchVariables.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .negationConditon(negationConditon?.applyValue({ args0 -> args0 }))
            .`operator`(
                `operator`.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transforms(
                transforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [MatchConditionArgs].
 */
@PulumiTagMarker
public class MatchConditionArgsBuilder internal constructor() {
    private var matchValues: Output<List<String>>? = null

    private var matchVariables: Output<List<MatchVariableArgs>>? = null

    private var negationConditon: Output<Boolean>? = null

    private var `operator`: Output<Either<String, WebApplicationFirewallOperator>>? = null

    private var transforms: Output<List<Either<String, WebApplicationFirewallTransform>>>? = null

    /**
     * @param value Match value.
     */
    @JvmName("xyyrmnxkmarfdhht")
    public suspend fun matchValues(`value`: Output<List<String>>) {
        this.matchValues = value
    }

    @JvmName("lrvscsgcqrusckki")
    public suspend fun matchValues(vararg values: Output<String>) {
        this.matchValues = Output.all(values.asList())
    }

    /**
     * @param values Match value.
     */
    @JvmName("khorlmmtrnnyxhkf")
    public suspend fun matchValues(values: List<Output<String>>) {
        this.matchValues = Output.all(values)
    }

    /**
     * @param value List of match variables.
     */
    @JvmName("hyjwtsbbrispbrtx")
    public suspend fun matchVariables(`value`: Output<List<MatchVariableArgs>>) {
        this.matchVariables = value
    }

    @JvmName("ebbjwasjlbekemms")
    public suspend fun matchVariables(vararg values: Output<MatchVariableArgs>) {
        this.matchVariables = Output.all(values.asList())
    }

    /**
     * @param values List of match variables.
     */
    @JvmName("exftttsxuubavycq")
    public suspend fun matchVariables(values: List<Output<MatchVariableArgs>>) {
        this.matchVariables = Output.all(values)
    }

    /**
     * @param value Whether this is negate condition or not.
     */
    @JvmName("eungofpgrejgrndv")
    public suspend fun negationConditon(`value`: Output<Boolean>) {
        this.negationConditon = value
    }

    /**
     * @param value The operator to be matched.
     */
    @JvmName("hgqljanwyvhfcubh")
    public suspend fun `operator`(`value`: Output<Either<String, WebApplicationFirewallOperator>>) {
        this.`operator` = value
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("vbqgkpgltmdeykhu")
    public suspend
    fun transforms(`value`: Output<List<Either<String, WebApplicationFirewallTransform>>>) {
        this.transforms = value
    }

    @JvmName("kwtcvjolsdxfjxkg")
    public suspend fun transforms(
        vararg
        values: Output<Either<String, WebApplicationFirewallTransform>>,
    ) {
        this.transforms = Output.all(values.asList())
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("tiylmlgeketmungq")
    public suspend
    fun transforms(values: List<Output<Either<String, WebApplicationFirewallTransform>>>) {
        this.transforms = Output.all(values)
    }

    /**
     * @param value Match value.
     */
    @JvmName("eklxfffetksfukno")
    public suspend fun matchValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param values Match value.
     */
    @JvmName("xaurmytrqsnmdgnc")
    public suspend fun matchValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchValues = mapped
    }

    /**
     * @param value List of match variables.
     */
    @JvmName("clpgvcpruordkgri")
    public suspend fun matchVariables(`value`: List<MatchVariableArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariables = mapped
    }

    /**
     * @param argument List of match variables.
     */
    @JvmName("jmehpepfesfypwod")
    public suspend fun matchVariables(argument: List<suspend MatchVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MatchVariableArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchVariables = mapped
    }

    /**
     * @param argument List of match variables.
     */
    @JvmName("qeoibumauefgqfhu")
    public suspend fun matchVariables(vararg argument: suspend MatchVariableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MatchVariableArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchVariables = mapped
    }

    /**
     * @param argument List of match variables.
     */
    @JvmName("hufjgajxaesljrlb")
    public suspend fun matchVariables(argument: suspend MatchVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MatchVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.matchVariables = mapped
    }

    /**
     * @param values List of match variables.
     */
    @JvmName("qkcxpiqprtygvrtq")
    public suspend fun matchVariables(vararg values: MatchVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchVariables = mapped
    }

    /**
     * @param value Whether this is negate condition or not.
     */
    @JvmName("yayehhspiiqxrvyu")
    public suspend fun negationConditon(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.negationConditon = mapped
    }

    /**
     * @param value The operator to be matched.
     */
    @JvmName("csurqtijvtncjima")
    public suspend fun `operator`(`value`: Either<String, WebApplicationFirewallOperator>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to be matched.
     */
    @JvmName("ypsfalvhvpadlkgi")
    public fun `operator`(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The operator to be matched.
     */
    @JvmName("uayaouejeqwbmgnh")
    public fun `operator`(`value`: WebApplicationFirewallOperator) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallOperator>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value List of transforms.
     */
    @JvmName("deakclmniolesslr")
    public suspend fun transforms(`value`: List<Either<String, WebApplicationFirewallTransform>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    /**
     * @param values List of transforms.
     */
    @JvmName("lpfukahqoylwjxgf")
    public suspend fun transforms(vararg values: Either<String, WebApplicationFirewallTransform>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transforms = mapped
    }

    internal fun build(): MatchConditionArgs = MatchConditionArgs(
        matchValues = matchValues ?: throw PulumiNullFieldException("matchValues"),
        matchVariables = matchVariables ?: throw PulumiNullFieldException("matchVariables"),
        negationConditon = negationConditon,
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        transforms = transforms,
    )
}
