@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.NetworkSecurityGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * NetworkSecurityGroup resource.
 * @property defaultSecurityRules The default security rules of network security group.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property flushConnection When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
 * @property id Resource ID.
 * @property location Resource location.
 * @property provisioningState The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property resourceGuid The resource GUID property of the network security group resource.
 * @property securityRules A collection of security rules of the network security group.
 * @property tags Resource tags.
 */
public data class NetworkSecurityGroupArgs(
    public val defaultSecurityRules: Output<List<SecurityRuleArgs>>? = null,
    public val etag: Output<String>? = null,
    public val flushConnection: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGuid: Output<String>? = null,
    public val securityRules: Output<List<SecurityRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.NetworkSecurityGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.NetworkSecurityGroupArgs =
        com.pulumi.azurenative.network.inputs.NetworkSecurityGroupArgs.builder()
            .defaultSecurityRules(
                defaultSecurityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .flushConnection(flushConnection?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGuid(resourceGuid?.applyValue({ args0 -> args0 }))
            .securityRules(
                securityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkSecurityGroupArgs].
 */
@PulumiTagMarker
public class NetworkSecurityGroupArgsBuilder internal constructor() {
    private var defaultSecurityRules: Output<List<SecurityRuleArgs>>? = null

    private var etag: Output<String>? = null

    private var flushConnection: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGuid: Output<String>? = null

    private var securityRules: Output<List<SecurityRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The default security rules of network security group.
     */
    @JvmName("yvipwvennbnaaxcj")
    public suspend fun defaultSecurityRules(`value`: Output<List<SecurityRuleArgs>>) {
        this.defaultSecurityRules = value
    }

    @JvmName("iklkamdcykahcasn")
    public suspend fun defaultSecurityRules(vararg values: Output<SecurityRuleArgs>) {
        this.defaultSecurityRules = Output.all(values.asList())
    }

    /**
     * @param values The default security rules of network security group.
     */
    @JvmName("rhvymocydvsapshc")
    public suspend fun defaultSecurityRules(values: List<Output<SecurityRuleArgs>>) {
        this.defaultSecurityRules = Output.all(values)
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("flilypkicshbfwhb")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     */
    @JvmName("yqouvwabxljpnafo")
    public suspend fun flushConnection(`value`: Output<Boolean>) {
        this.flushConnection = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("oimvivnguanntata")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ldaiawfmmfkcftem")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("reedwtcdpgxhjwqh")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The resource GUID property of the network security group resource.
     */
    @JvmName("tpxfarsryvhjtjxp")
    public suspend fun resourceGuid(`value`: Output<String>) {
        this.resourceGuid = value
    }

    /**
     * @param value A collection of security rules of the network security group.
     */
    @JvmName("fgamknqteeadmtqs")
    public suspend fun securityRules(`value`: Output<List<SecurityRuleArgs>>) {
        this.securityRules = value
    }

    @JvmName("ocakoyhymcylqayl")
    public suspend fun securityRules(vararg values: Output<SecurityRuleArgs>) {
        this.securityRules = Output.all(values.asList())
    }

    /**
     * @param values A collection of security rules of the network security group.
     */
    @JvmName("nbkqckfsujllsfmy")
    public suspend fun securityRules(values: List<Output<SecurityRuleArgs>>) {
        this.securityRules = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fcbhkajfttjhthrs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The default security rules of network security group.
     */
    @JvmName("xqxvmdcrcnfpdimp")
    public suspend fun defaultSecurityRules(`value`: List<SecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSecurityRules = mapped
    }

    /**
     * @param argument The default security rules of network security group.
     */
    @JvmName("mlkdovbjifrbaqhu")
    public suspend
    fun defaultSecurityRules(argument: List<suspend SecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultSecurityRules = mapped
    }

    /**
     * @param argument The default security rules of network security group.
     */
    @JvmName("hutxhkhkyivyokub")
    public suspend fun defaultSecurityRules(
        vararg
        argument: suspend SecurityRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultSecurityRules = mapped
    }

    /**
     * @param argument The default security rules of network security group.
     */
    @JvmName("jbeuluwgykjrjkwc")
    public suspend fun defaultSecurityRules(argument: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.defaultSecurityRules = mapped
    }

    /**
     * @param values The default security rules of network security group.
     */
    @JvmName("qyfiudqsvxgadnpd")
    public suspend fun defaultSecurityRules(vararg values: SecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultSecurityRules = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("wfhvrlwekcaohtqx")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.
     */
    @JvmName("qjtccyxovodrqttw")
    public suspend fun flushConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flushConnection = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fvuvqnetokgqrvik")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dpslivxhhuvgpgfv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("lsfvsxfimlrfchfg")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource GUID property of the network security group resource.
     */
    @JvmName("kjgsmswosjfvmufu")
    public suspend fun resourceGuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuid = mapped
    }

    /**
     * @param value A collection of security rules of the network security group.
     */
    @JvmName("hijhhhplgktuypkc")
    public suspend fun securityRules(`value`: List<SecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     */
    @JvmName("pexrbcpmgluqtqay")
    public suspend fun securityRules(argument: List<suspend SecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     */
    @JvmName("tiwoevqreqhpeajo")
    public suspend fun securityRules(vararg argument: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecurityRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param argument A collection of security rules of the network security group.
     */
    @JvmName("pncsvldghpohgwpw")
    public suspend fun securityRules(argument: suspend SecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.securityRules = mapped
    }

    /**
     * @param values A collection of security rules of the network security group.
     */
    @JvmName("wleglngnnaetvjox")
    public suspend fun securityRules(vararg values: SecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityRules = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ovlrgokbchhutvkg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lomudtjbhybnrmms")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkSecurityGroupArgs = NetworkSecurityGroupArgs(
        defaultSecurityRules = defaultSecurityRules,
        etag = etag,
        flushConnection = flushConnection,
        id = id,
        location = location,
        provisioningState = provisioningState,
        resourceGuid = resourceGuid,
        securityRules = securityRules,
        tags = tags,
    )
}
