@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.OutboundRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.LoadBalancerOutboundRuleProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Outbound rule of the load balancer.
 * @property allocatedOutboundPorts The number of outbound ports to be used for NAT.
 * @property backendAddressPool A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property frontendIPConfigurations The Frontend IP addresses of the load balancer.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection.
 * @property name The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
 * @property protocol The protocol for the outbound rule in load balancer.
 */
public data class OutboundRuleArgs(
    public val allocatedOutboundPorts: Output<Int>? = null,
    public val backendAddressPool: Output<SubResourceArgs>,
    public val enableTcpReset: Output<Boolean>? = null,
    public val frontendIPConfigurations: Output<List<SubResourceArgs>>,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val protocol: Output<Either<String, LoadBalancerOutboundRuleProtocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.OutboundRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.OutboundRuleArgs =
        com.pulumi.azurenative.network.inputs.OutboundRuleArgs.builder()
            .allocatedOutboundPorts(allocatedOutboundPorts?.applyValue({ args0 -> args0 }))
            .backendAddressPool(
                backendAddressPool.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableTcpReset(enableTcpReset?.applyValue({ args0 -> args0 }))
            .frontendIPConfigurations(
                frontendIPConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OutboundRuleArgs].
 */
@PulumiTagMarker
public class OutboundRuleArgsBuilder internal constructor() {
    private var allocatedOutboundPorts: Output<Int>? = null

    private var backendAddressPool: Output<SubResourceArgs>? = null

    private var enableTcpReset: Output<Boolean>? = null

    private var frontendIPConfigurations: Output<List<SubResourceArgs>>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var name: Output<String>? = null

    private var protocol: Output<Either<String, LoadBalancerOutboundRuleProtocol>>? = null

    /**
     * @param value The number of outbound ports to be used for NAT.
     */
    @JvmName("rrvhkrjclywqyfcr")
    public suspend fun allocatedOutboundPorts(`value`: Output<Int>) {
        this.allocatedOutboundPorts = value
    }

    /**
     * @param value A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("hrhruvtkxnyomoyb")
    public suspend fun backendAddressPool(`value`: Output<SubResourceArgs>) {
        this.backendAddressPool = value
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("cjjihpcmyqtimuvp")
    public suspend fun enableTcpReset(`value`: Output<Boolean>) {
        this.enableTcpReset = value
    }

    /**
     * @param value The Frontend IP addresses of the load balancer.
     */
    @JvmName("kgpvkavojblvhxcx")
    public suspend fun frontendIPConfigurations(`value`: Output<List<SubResourceArgs>>) {
        this.frontendIPConfigurations = value
    }

    @JvmName("ufeqluhowoxwixmk")
    public suspend fun frontendIPConfigurations(vararg values: Output<SubResourceArgs>) {
        this.frontendIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The Frontend IP addresses of the load balancer.
     */
    @JvmName("vfmsbrwsjuubitjw")
    public suspend fun frontendIPConfigurations(values: List<Output<SubResourceArgs>>) {
        this.frontendIPConfigurations = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bimiowqhqmhrpcbh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The timeout for the TCP idle connection.
     */
    @JvmName("eypmibwhwrulybgv")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("qfcowpsfarowtxpd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The protocol for the outbound rule in load balancer.
     */
    @JvmName("vebwalwyekwdnsvj")
    public suspend fun protocol(`value`: Output<Either<String, LoadBalancerOutboundRuleProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The number of outbound ports to be used for NAT.
     */
    @JvmName("qnwpcjpdncekpklf")
    public suspend fun allocatedOutboundPorts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocatedOutboundPorts = mapped
    }

    /**
     * @param value A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("qjhbhqgepuxpbvco")
    public suspend fun backendAddressPool(`value`: SubResourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPool = mapped
    }

    /**
     * @param argument A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
     */
    @JvmName("kbvnfhaatrgeohdw")
    public suspend fun backendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backendAddressPool = mapped
    }

    /**
     * @param value Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
     */
    @JvmName("jtysmfgcaykluqen")
    public suspend fun enableTcpReset(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTcpReset = mapped
    }

    /**
     * @param value The Frontend IP addresses of the load balancer.
     */
    @JvmName("lhucsxggralgdmii")
    public suspend fun frontendIPConfigurations(`value`: List<SubResourceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument The Frontend IP addresses of the load balancer.
     */
    @JvmName("nbilblauwcaahjtf")
    public suspend
    fun frontendIPConfigurations(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument The Frontend IP addresses of the load balancer.
     */
    @JvmName("ryjfstwvkfvjtqvi")
    public suspend fun frontendIPConfigurations(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument The Frontend IP addresses of the load balancer.
     */
    @JvmName("uonurhuhftvdwiud")
    public suspend fun frontendIPConfigurations(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param values The Frontend IP addresses of the load balancer.
     */
    @JvmName("kibjbitvfeqstlso")
    public suspend fun frontendIPConfigurations(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rqqgmuplqmmteogx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The timeout for the TCP idle connection.
     */
    @JvmName("avstlcgheppfxqbp")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.
     */
    @JvmName("ymmhxlhsuxskamgy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The protocol for the outbound rule in load balancer.
     */
    @JvmName("gfaiqtjkamhbkaan")
    public suspend fun protocol(`value`: Either<String, LoadBalancerOutboundRuleProtocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol for the outbound rule in load balancer.
     */
    @JvmName("gplihlmoeokkpdrt")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerOutboundRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol for the outbound rule in load balancer.
     */
    @JvmName("jasucpsepvaflbpp")
    public fun protocol(`value`: LoadBalancerOutboundRuleProtocol) {
        val toBeMapped = Either.ofRight<String, LoadBalancerOutboundRuleProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): OutboundRuleArgs = OutboundRuleArgs(
        allocatedOutboundPorts = allocatedOutboundPorts,
        backendAddressPool = backendAddressPool ?: throw PulumiNullFieldException("backendAddressPool"),
        enableTcpReset = enableTcpReset,
        frontendIPConfigurations = frontendIPConfigurations ?: throw
            PulumiNullFieldException("frontendIPConfigurations"),
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        name = name,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
