@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PolicySettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallEnabledState
import com.pulumi.azurenative.network.kotlin.enums.WebApplicationFirewallMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines contents of a web application firewall global configuration.
 * @property customBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property customBlockResponseStatusCode If the action type is block, customer can override the response status code.
 * @property fileUploadEnforcement Whether allow WAF to enforce file upload limits.
 * @property fileUploadLimitInMb Maximum file upload size in Mb for WAF.
 * @property logScrubbing To scrub sensitive log fields
 * @property maxRequestBodySizeInKb Maximum request body size in Kb for WAF.
 * @property mode The mode of the policy.
 * @property requestBodyCheck Whether to allow WAF to check request Body.
 * @property requestBodyEnforcement Whether allow WAF to enforce request body limits.
 * @property requestBodyInspectLimitInKB Max inspection limit in KB for request body inspection for WAF.
 * @property state The state of the policy.
 */
public data class PolicySettingsArgs(
    public val customBlockResponseBody: Output<String>? = null,
    public val customBlockResponseStatusCode: Output<Int>? = null,
    public val fileUploadEnforcement: Output<Boolean>? = null,
    public val fileUploadLimitInMb: Output<Int>? = null,
    public val logScrubbing: Output<PolicySettingsLogScrubbingArgs>? = null,
    public val maxRequestBodySizeInKb: Output<Int>? = null,
    public val mode: Output<Either<String, WebApplicationFirewallMode>>? = null,
    public val requestBodyCheck: Output<Boolean>? = null,
    public val requestBodyEnforcement: Output<Boolean>? = null,
    public val requestBodyInspectLimitInKB: Output<Int>? = null,
    public val state: Output<Either<String, WebApplicationFirewallEnabledState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PolicySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PolicySettingsArgs =
        com.pulumi.azurenative.network.inputs.PolicySettingsArgs.builder()
            .customBlockResponseBody(customBlockResponseBody?.applyValue({ args0 -> args0 }))
            .customBlockResponseStatusCode(customBlockResponseStatusCode?.applyValue({ args0 -> args0 }))
            .fileUploadEnforcement(fileUploadEnforcement?.applyValue({ args0 -> args0 }))
            .fileUploadLimitInMb(fileUploadLimitInMb?.applyValue({ args0 -> args0 }))
            .logScrubbing(logScrubbing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxRequestBodySizeInKb(maxRequestBodySizeInKb?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .requestBodyCheck(requestBodyCheck?.applyValue({ args0 -> args0 }))
            .requestBodyEnforcement(requestBodyEnforcement?.applyValue({ args0 -> args0 }))
            .requestBodyInspectLimitInKB(requestBodyInspectLimitInKB?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySettingsArgs].
 */
@PulumiTagMarker
public class PolicySettingsArgsBuilder internal constructor() {
    private var customBlockResponseBody: Output<String>? = null

    private var customBlockResponseStatusCode: Output<Int>? = null

    private var fileUploadEnforcement: Output<Boolean>? = null

    private var fileUploadLimitInMb: Output<Int>? = null

    private var logScrubbing: Output<PolicySettingsLogScrubbingArgs>? = null

    private var maxRequestBodySizeInKb: Output<Int>? = null

    private var mode: Output<Either<String, WebApplicationFirewallMode>>? = null

    private var requestBodyCheck: Output<Boolean>? = null

    private var requestBodyEnforcement: Output<Boolean>? = null

    private var requestBodyInspectLimitInKB: Output<Int>? = null

    private var state: Output<Either<String, WebApplicationFirewallEnabledState>>? = null

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("ofahpuhcobnkgqja")
    public suspend fun customBlockResponseBody(`value`: Output<String>) {
        this.customBlockResponseBody = value
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("kujjklfarchmdtxj")
    public suspend fun customBlockResponseStatusCode(`value`: Output<Int>) {
        this.customBlockResponseStatusCode = value
    }

    /**
     * @param value Whether allow WAF to enforce file upload limits.
     */
    @JvmName("lyapbmgyemeethau")
    public suspend fun fileUploadEnforcement(`value`: Output<Boolean>) {
        this.fileUploadEnforcement = value
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("mtwqtqadruxjodsh")
    public suspend fun fileUploadLimitInMb(`value`: Output<Int>) {
        this.fileUploadLimitInMb = value
    }

    /**
     * @param value To scrub sensitive log fields
     */
    @JvmName("msgctkscsvvmyupl")
    public suspend fun logScrubbing(`value`: Output<PolicySettingsLogScrubbingArgs>) {
        this.logScrubbing = value
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("cvrkofirbhjurgao")
    public suspend fun maxRequestBodySizeInKb(`value`: Output<Int>) {
        this.maxRequestBodySizeInKb = value
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("cborlbwiwwapfdme")
    public suspend fun mode(`value`: Output<Either<String, WebApplicationFirewallMode>>) {
        this.mode = value
    }

    /**
     * @param value Whether to allow WAF to check request Body.
     */
    @JvmName("kdxwpgbpgowmutpp")
    public suspend fun requestBodyCheck(`value`: Output<Boolean>) {
        this.requestBodyCheck = value
    }

    /**
     * @param value Whether allow WAF to enforce request body limits.
     */
    @JvmName("wtjnorfecluqwtnq")
    public suspend fun requestBodyEnforcement(`value`: Output<Boolean>) {
        this.requestBodyEnforcement = value
    }

    /**
     * @param value Max inspection limit in KB for request body inspection for WAF.
     */
    @JvmName("uimlpsvsbpjswebe")
    public suspend fun requestBodyInspectLimitInKB(`value`: Output<Int>) {
        this.requestBodyInspectLimitInKB = value
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("kymnelsbtegbrheo")
    public suspend fun state(`value`: Output<Either<String, WebApplicationFirewallEnabledState>>) {
        this.state = value
    }

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("cjwflbylgjaafdrp")
    public suspend fun customBlockResponseBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseBody = mapped
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("wybmlbnxakiwlagc")
    public suspend fun customBlockResponseStatusCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseStatusCode = mapped
    }

    /**
     * @param value Whether allow WAF to enforce file upload limits.
     */
    @JvmName("okpgibxymoxwgjle")
    public suspend fun fileUploadEnforcement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileUploadEnforcement = mapped
    }

    /**
     * @param value Maximum file upload size in Mb for WAF.
     */
    @JvmName("oqginqvrncjbvooj")
    public suspend fun fileUploadLimitInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileUploadLimitInMb = mapped
    }

    /**
     * @param value To scrub sensitive log fields
     */
    @JvmName("mkbcmodgvvdbccer")
    public suspend fun logScrubbing(`value`: PolicySettingsLogScrubbingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logScrubbing = mapped
    }

    /**
     * @param argument To scrub sensitive log fields
     */
    @JvmName("oasoefbmypqntunm")
    public suspend
    fun logScrubbing(argument: suspend PolicySettingsLogScrubbingArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySettingsLogScrubbingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logScrubbing = mapped
    }

    /**
     * @param value Maximum request body size in Kb for WAF.
     */
    @JvmName("duqxdndefgjfyjaa")
    public suspend fun maxRequestBodySizeInKb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRequestBodySizeInKb = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("tdtegqfvrrvhbhhv")
    public suspend fun mode(`value`: Either<String, WebApplicationFirewallMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("wobvsybfawheaigx")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The mode of the policy.
     */
    @JvmName("bjbchhrcrtmbdbat")
    public fun mode(`value`: WebApplicationFirewallMode) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Whether to allow WAF to check request Body.
     */
    @JvmName("kysqqieksggmxndl")
    public suspend fun requestBodyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    /**
     * @param value Whether allow WAF to enforce request body limits.
     */
    @JvmName("xbypykpcwbegrmev")
    public suspend fun requestBodyEnforcement(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyEnforcement = mapped
    }

    /**
     * @param value Max inspection limit in KB for request body inspection for WAF.
     */
    @JvmName("hcxsswbqptdjpdtt")
    public suspend fun requestBodyInspectLimitInKB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyInspectLimitInKB = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("jttqjnrguwkxblpp")
    public suspend fun state(`value`: Either<String, WebApplicationFirewallEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("johrmowhtfwsvtto")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WebApplicationFirewallEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the policy.
     */
    @JvmName("qhdgaqisypbqkupy")
    public fun state(`value`: WebApplicationFirewallEnabledState) {
        val toBeMapped = Either.ofRight<String, WebApplicationFirewallEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): PolicySettingsArgs = PolicySettingsArgs(
        customBlockResponseBody = customBlockResponseBody,
        customBlockResponseStatusCode = customBlockResponseStatusCode,
        fileUploadEnforcement = fileUploadEnforcement,
        fileUploadLimitInMb = fileUploadLimitInMb,
        logScrubbing = logScrubbing,
        maxRequestBodySizeInKb = maxRequestBodySizeInKb,
        mode = mode,
        requestBodyCheck = requestBodyCheck,
        requestBodyEnforcement = requestBodyEnforcement,
        requestBodyInspectLimitInKB = requestBodyInspectLimitInKB,
        state = state,
    )
}
