@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of information about the state of the connection between service consumer and provider.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The reason for approval/rejection of the connection.
 * @property status Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.network.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("xqrwetepufgoqfgo")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("mxqbconkplamthuu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("syidpohypupqxkvm")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A message indicating if changes on the service provider require any updates on the consumer.
     */
    @JvmName("mjslnjhasjqaikof")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value The reason for approval/rejection of the connection.
     */
    @JvmName("ymifcpoowjuxdprs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
     */
    @JvmName("pbfmgwivojxpusna")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
