@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PublicIPAddressArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DeleteOptions
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.azurenative.network.kotlin.enums.PublicIPAddressMigrationPhase
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Public IP address resource.
 * @property ddosSettings The DDoS protection custom policy associated with the public IP address.
 * @property deleteOption Specify what happens to the public IP address when the VM using it is deleted
 * @property dnsSettings The FQDN of the DNS record associated with the public IP address.
 * @property extendedLocation The extended location of the public ip address.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipAddress The IP address associated with the public IP address resource.
 * @property ipTags The list of tags associated with the public IP address.
 * @property linkedPublicIPAddress The linked public IP address of the public IP address resource.
 * @property location Resource location.
 * @property migrationPhase Migration phase of Public IP Address.
 * @property natGateway The NatGateway for the Public IP address.
 * @property publicIPAddressVersion The public IP address version.
 * @property publicIPAllocationMethod The public IP address allocation method.
 * @property publicIPPrefix The Public IP Prefix this Public IP Address should be allocated from.
 * @property servicePublicIPAddress The service public IP address of the public IP address resource.
 * @property sku The public IP address SKU.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class PublicIPAddressArgs(
    public val ddosSettings: Output<DdosSettingsArgs>? = null,
    public val deleteOption: Output<Either<String, DeleteOptions>>? = null,
    public val dnsSettings: Output<PublicIPAddressDnsSettingsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val id: Output<String>? = null,
    public val idleTimeoutInMinutes: Output<Int>? = null,
    public val ipAddress: Output<String>? = null,
    public val ipTags: Output<List<IpTagArgs>>? = null,
    public val linkedPublicIPAddress: Output<PublicIPAddressArgs>? = null,
    public val location: Output<String>? = null,
    public val migrationPhase: Output<Either<String, PublicIPAddressMigrationPhase>>? = null,
    public val natGateway: Output<NatGatewayArgs>? = null,
    public val publicIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val publicIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPPrefix: Output<SubResourceArgs>? = null,
    public val servicePublicIPAddress: Output<PublicIPAddressArgs>? = null,
    public val sku: Output<PublicIPAddressSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PublicIPAddressArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PublicIPAddressArgs =
        com.pulumi.azurenative.network.inputs.PublicIPAddressArgs.builder()
            .ddosSettings(ddosSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deleteOption(
                deleteOption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .idleTimeoutInMinutes(idleTimeoutInMinutes?.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .linkedPublicIPAddress(
                linkedPublicIPAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .migrationPhase(
                migrationPhase?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicIPAddressVersion(
                publicIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAllocationMethod(
                publicIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPPrefix(publicIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .servicePublicIPAddress(
                servicePublicIPAddress?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PublicIPAddressArgs].
 */
@PulumiTagMarker
public class PublicIPAddressArgsBuilder internal constructor() {
    private var ddosSettings: Output<DdosSettingsArgs>? = null

    private var deleteOption: Output<Either<String, DeleteOptions>>? = null

    private var dnsSettings: Output<PublicIPAddressDnsSettingsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var id: Output<String>? = null

    private var idleTimeoutInMinutes: Output<Int>? = null

    private var ipAddress: Output<String>? = null

    private var ipTags: Output<List<IpTagArgs>>? = null

    private var linkedPublicIPAddress: Output<PublicIPAddressArgs>? = null

    private var location: Output<String>? = null

    private var migrationPhase: Output<Either<String, PublicIPAddressMigrationPhase>>? = null

    private var natGateway: Output<NatGatewayArgs>? = null

    private var publicIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var publicIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPPrefix: Output<SubResourceArgs>? = null

    private var servicePublicIPAddress: Output<PublicIPAddressArgs>? = null

    private var sku: Output<PublicIPAddressSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("rtklyhmhfutlrxbk")
    public suspend fun ddosSettings(`value`: Output<DdosSettingsArgs>) {
        this.ddosSettings = value
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("tmtrdbewjjdxwcox")
    public suspend fun deleteOption(`value`: Output<Either<String, DeleteOptions>>) {
        this.deleteOption = value
    }

    /**
     * @param value The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("atbpmucsktvyqdcn")
    public suspend fun dnsSettings(`value`: Output<PublicIPAddressDnsSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("pooxxvpbdkjqjqcu")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ukjmwxnljumvsyrb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("nouaivjhmheqaeco")
    public suspend fun idleTimeoutInMinutes(`value`: Output<Int>) {
        this.idleTimeoutInMinutes = value
    }

    /**
     * @param value The IP address associated with the public IP address resource.
     */
    @JvmName("lgdlcnktewbvlyae")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value The list of tags associated with the public IP address.
     */
    @JvmName("euwfxpeniipheivj")
    public suspend fun ipTags(`value`: Output<List<IpTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("jigjjrnukqhexyva")
    public suspend fun ipTags(vararg values: Output<IpTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of tags associated with the public IP address.
     */
    @JvmName("jmcjtluaveqlxoty")
    public suspend fun ipTags(values: List<Output<IpTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value The linked public IP address of the public IP address resource.
     */
    @JvmName("gruhjmsmkqngbvxy")
    public suspend fun linkedPublicIPAddress(`value`: Output<PublicIPAddressArgs>) {
        this.linkedPublicIPAddress = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yaeptprbhtupvqgu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("klxjfqvlycakoopb")
    public suspend
    fun migrationPhase(`value`: Output<Either<String, PublicIPAddressMigrationPhase>>) {
        this.migrationPhase = value
    }

    /**
     * @param value The NatGateway for the Public IP address.
     */
    @JvmName("tfqtwdcqktyvhaon")
    public suspend fun natGateway(`value`: Output<NatGatewayArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("gpxndikwjufeyija")
    public suspend fun publicIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.publicIPAddressVersion = value
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("ltfxbcufurdrqxmu")
    public suspend fun publicIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.publicIPAllocationMethod = value
    }

    /**
     * @param value The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("qcmgvjcosmuapdhd")
    public suspend fun publicIPPrefix(`value`: Output<SubResourceArgs>) {
        this.publicIPPrefix = value
    }

    /**
     * @param value The service public IP address of the public IP address resource.
     */
    @JvmName("eisophgsiwlnhmjg")
    public suspend fun servicePublicIPAddress(`value`: Output<PublicIPAddressArgs>) {
        this.servicePublicIPAddress = value
    }

    /**
     * @param value The public IP address SKU.
     */
    @JvmName("chuwttqnoirmlvjc")
    public suspend fun sku(`value`: Output<PublicIPAddressSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jgkkmubidbmcyynr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("tidrdngeyhtqdrmk")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("mmkstgkwywnuwfbh")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("kiobwqjetaxarmco")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("arrduyifqpotgoot")
    public suspend fun ddosSettings(`value`: DdosSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosSettings = mapped
    }

    /**
     * @param argument The DDoS protection custom policy associated with the public IP address.
     */
    @JvmName("ngpwllumahganvum")
    public suspend fun ddosSettings(argument: suspend DdosSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DdosSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ddosSettings = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("hvkivkojtcjsxwli")
    public suspend fun deleteOption(`value`: Either<String, DeleteOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("pykeiwampowybjve")
    public fun deleteOption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value Specify what happens to the public IP address when the VM using it is deleted
     */
    @JvmName("hiwilcarqgptqjun")
    public fun deleteOption(`value`: DeleteOptions) {
        val toBeMapped = Either.ofRight<String, DeleteOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOption = mapped
    }

    /**
     * @param value The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("neepftjtmeumfssi")
    public suspend fun dnsSettings(`value`: PublicIPAddressDnsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument The FQDN of the DNS record associated with the public IP address.
     */
    @JvmName("ksfjfuuxehjgtlrt")
    public suspend
    fun dnsSettings(argument: suspend PublicIPAddressDnsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressDnsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("vltpakjnlrhogowq")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the public ip address.
     */
    @JvmName("fpdsepwyapypfooq")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dxpqxpsdnpojatnt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The idle timeout of the public IP address.
     */
    @JvmName("oiasbvsbfteghoxs")
    public suspend fun idleTimeoutInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeoutInMinutes = mapped
    }

    /**
     * @param value The IP address associated with the public IP address resource.
     */
    @JvmName("rguplnbcsejbdqye")
    public suspend fun ipAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value The list of tags associated with the public IP address.
     */
    @JvmName("gijielaahtvqeolh")
    public suspend fun ipTags(`value`: List<IpTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("ktkrvqhmxmnxjhdn")
    public suspend fun ipTags(argument: List<suspend IpTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("ckbkcvccjgngfnuu")
    public suspend fun ipTags(vararg argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP address.
     */
    @JvmName("nkpjshbscfrcotok")
    public suspend fun ipTags(argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of tags associated with the public IP address.
     */
    @JvmName("lfqaeshxvwoxjdvx")
    public suspend fun ipTags(vararg values: IpTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value The linked public IP address of the public IP address resource.
     */
    @JvmName("crcvlnlfleogidby")
    public suspend fun linkedPublicIPAddress(`value`: PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedPublicIPAddress = mapped
    }

    /**
     * @param argument The linked public IP address of the public IP address resource.
     */
    @JvmName("oxdoxekjghbityxt")
    public suspend
    fun linkedPublicIPAddress(argument: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedPublicIPAddress = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("joqcxuqtgxvvokid")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("uvwlkpvowmbfolts")
    public suspend fun migrationPhase(`value`: Either<String, PublicIPAddressMigrationPhase>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("ttjrkisbajvhhfun")
    public fun migrationPhase(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPAddressMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value Migration phase of Public IP Address.
     */
    @JvmName("supthrborcbfaupr")
    public fun migrationPhase(`value`: PublicIPAddressMigrationPhase) {
        val toBeMapped = Either.ofRight<String, PublicIPAddressMigrationPhase>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.migrationPhase = mapped
    }

    /**
     * @param value The NatGateway for the Public IP address.
     */
    @JvmName("hyraukgylitymphc")
    public suspend fun natGateway(`value`: NatGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument The NatGateway for the Public IP address.
     */
    @JvmName("bdocxpwhgvjlhdgq")
    public suspend fun natGateway(argument: suspend NatGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = NatGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("icblhwydrslacvrc")
    public suspend fun publicIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("haplecwkyejacwqe")
    public fun publicIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("bkbgnpjrafinvskf")
    public fun publicIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("kugjififrbptstqa")
    public suspend fun publicIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("mlbwwrbhrnhrelwq")
    public fun publicIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The public IP address allocation method.
     */
    @JvmName("vgsyakjrleypsouy")
    public fun publicIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAllocationMethod = mapped
    }

    /**
     * @param value The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("wmlshgntwibctcmn")
    public suspend fun publicIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPPrefix = mapped
    }

    /**
     * @param argument The Public IP Prefix this Public IP Address should be allocated from.
     */
    @JvmName("rstboypvblvkadlj")
    public suspend fun publicIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPPrefix = mapped
    }

    /**
     * @param value The service public IP address of the public IP address resource.
     */
    @JvmName("botukptlgnfhfagr")
    public suspend fun servicePublicIPAddress(`value`: PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePublicIPAddress = mapped
    }

    /**
     * @param argument The service public IP address of the public IP address resource.
     */
    @JvmName("gfcefbrvfttkcbjv")
    public suspend
    fun servicePublicIPAddress(argument: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePublicIPAddress = mapped
    }

    /**
     * @param value The public IP address SKU.
     */
    @JvmName("qjlilgvbyuoyvgwj")
    public suspend fun sku(`value`: PublicIPAddressSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The public IP address SKU.
     */
    @JvmName("tuatukhmwdeahhsh")
    public suspend fun sku(argument: suspend PublicIPAddressSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rcpepgxtojosfbnh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uvgmtmyfrnkcxgva")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("tjtkhskrsaddmbxe")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("wvxbuvxhcspcsgds")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): PublicIPAddressArgs = PublicIPAddressArgs(
        ddosSettings = ddosSettings,
        deleteOption = deleteOption,
        dnsSettings = dnsSettings,
        extendedLocation = extendedLocation,
        id = id,
        idleTimeoutInMinutes = idleTimeoutInMinutes,
        ipAddress = ipAddress,
        ipTags = ipTags,
        linkedPublicIPAddress = linkedPublicIPAddress,
        location = location,
        migrationPhase = migrationPhase,
        natGateway = natGateway,
        publicIPAddressVersion = publicIPAddressVersion,
        publicIPAllocationMethod = publicIPAllocationMethod,
        publicIPPrefix = publicIPPrefix,
        servicePublicIPAddress = servicePublicIPAddress,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
