@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PublicIPPrefixSkuName
import com.pulumi.azurenative.network.kotlin.enums.PublicIPPrefixSkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of a public IP prefix.
 * @property name Name of a public IP prefix SKU.
 * @property tier Tier of a public IP prefix SKU.
 */
public data class PublicIPPrefixSkuArgs(
    public val name: Output<Either<String, PublicIPPrefixSkuName>>? = null,
    public val tier: Output<Either<String, PublicIPPrefixSkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs =
        com.pulumi.azurenative.network.inputs.PublicIPPrefixSkuArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PublicIPPrefixSkuArgs].
 */
@PulumiTagMarker
public class PublicIPPrefixSkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, PublicIPPrefixSkuName>>? = null

    private var tier: Output<Either<String, PublicIPPrefixSkuTier>>? = null

    /**
     * @param value Name of a public IP prefix SKU.
     */
    @JvmName("bgutglbyerunqamg")
    public suspend fun name(`value`: Output<Either<String, PublicIPPrefixSkuName>>) {
        this.name = value
    }

    /**
     * @param value Tier of a public IP prefix SKU.
     */
    @JvmName("wujiullirjxvfjja")
    public suspend fun tier(`value`: Output<Either<String, PublicIPPrefixSkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Name of a public IP prefix SKU.
     */
    @JvmName("eemfkllkgcsvvdvi")
    public suspend fun name(`value`: Either<String, PublicIPPrefixSkuName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a public IP prefix SKU.
     */
    @JvmName("emsiihjsvjwdcooq")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPPrefixSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of a public IP prefix SKU.
     */
    @JvmName("mvpopuduqofeelmi")
    public fun name(`value`: PublicIPPrefixSkuName) {
        val toBeMapped = Either.ofRight<String, PublicIPPrefixSkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of a public IP prefix SKU.
     */
    @JvmName("xcmbdjwppgbxkmwe")
    public suspend fun tier(`value`: Either<String, PublicIPPrefixSkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a public IP prefix SKU.
     */
    @JvmName("ekuyvrgqukwppwaw")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPPrefixSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of a public IP prefix SKU.
     */
    @JvmName("idadjxlthwgmdkvv")
    public fun tier(`value`: PublicIPPrefixSkuTier) {
        val toBeMapped = Either.ofRight<String, PublicIPPrefixSkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): PublicIPPrefixSkuArgs = PublicIPPrefixSkuArgs(
        name = name,
        tier = tier,
    )
}
