@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RouteFilterRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.Access
import com.pulumi.azurenative.network.kotlin.enums.RouteFilterRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Route Filter Rule Resource.
 * @property access The access type of the rule.
 * @property communities The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routeFilterRuleType The rule type of the rule.
 */
public data class RouteFilterRuleArgs(
    public val access: Output<Either<String, Access>>,
    public val communities: Output<List<String>>,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routeFilterRuleType: Output<Either<String, RouteFilterRuleType>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RouteFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RouteFilterRuleArgs =
        com.pulumi.azurenative.network.inputs.RouteFilterRuleArgs.builder()
            .access(
                access.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .communities(communities.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routeFilterRuleType(
                routeFilterRuleType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [RouteFilterRuleArgs].
 */
@PulumiTagMarker
public class RouteFilterRuleArgsBuilder internal constructor() {
    private var access: Output<Either<String, Access>>? = null

    private var communities: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var routeFilterRuleType: Output<Either<String, RouteFilterRuleType>>? = null

    /**
     * @param value The access type of the rule.
     */
    @JvmName("oymqvtgtbqoefekn")
    public suspend fun access(`value`: Output<Either<String, Access>>) {
        this.access = value
    }

    /**
     * @param value The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("ohouwbkgkjhnjsrq")
    public suspend fun communities(`value`: Output<List<String>>) {
        this.communities = value
    }

    @JvmName("akdifeqsdfjplpyx")
    public suspend fun communities(vararg values: Output<String>) {
        this.communities = Output.all(values.asList())
    }

    /**
     * @param values The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("djasckfjhymuasbg")
    public suspend fun communities(values: List<Output<String>>) {
        this.communities = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mvuhqfhjsxfcfhlf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xrfdbgtmjkefyyhn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("wogmvquaygtberji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("lcxfcteyggveqwfe")
    public suspend fun routeFilterRuleType(`value`: Output<Either<String, RouteFilterRuleType>>) {
        this.routeFilterRuleType = value
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("jhxoybgkuyciaxma")
    public suspend fun access(`value`: Either<String, Access>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("qxiscutjigwcrhnn")
    public fun access(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The access type of the rule.
     */
    @JvmName("ksmjrjxtjncscaga")
    public fun access(`value`: Access) {
        val toBeMapped = Either.ofRight<String, Access>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.access = mapped
    }

    /**
     * @param value The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("abpapqmqlwsxobsd")
    public suspend fun communities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param values The collection for bgp community values to filter on. e.g. ['12076:5010','12076:5020'].
     */
    @JvmName("fiyuidplyfxfswsy")
    public suspend fun communities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("trbghkpcxrcngnnp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("snlqubloxiahsnlf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("fugsjnqwtuicofgb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("bnkbpexsddvqxsvf")
    public suspend fun routeFilterRuleType(`value`: Either<String, RouteFilterRuleType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("tumspnfehenlagfd")
    public fun routeFilterRuleType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteFilterRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    /**
     * @param value The rule type of the rule.
     */
    @JvmName("qkxdsachkykvhiln")
    public fun routeFilterRuleType(`value`: RouteFilterRuleType) {
        val toBeMapped = Either.ofRight<String, RouteFilterRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterRuleType = mapped
    }

    internal fun build(): RouteFilterRuleArgs = RouteFilterRuleArgs(
        access = access ?: throw PulumiNullFieldException("access"),
        communities = communities ?: throw PulumiNullFieldException("communities"),
        id = id,
        location = location,
        name = name,
        routeFilterRuleType = routeFilterRuleType ?: throw PulumiNullFieldException("routeFilterRuleType"),
    )
}
