@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Route table resource.
 * @property disableBgpRoutePropagation Whether to disable the routes learned by BGP on that route table. True means disable.
 * @property etag Gets a unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property provisioningState The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
 * @property routes Collection of routes contained within a route table.
 * @property tags Resource tags.
 */
public data class RouteTableArgs(
    public val disableBgpRoutePropagation: Output<Boolean>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val provisioningState: Output<String>? = null,
    public val routes: Output<List<RouteArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RouteTableArgs =
        com.pulumi.azurenative.network.inputs.RouteTableArgs.builder()
            .disableBgpRoutePropagation(disableBgpRoutePropagation?.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var disableBgpRoutePropagation: Output<Boolean>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var provisioningState: Output<String>? = null

    private var routes: Output<List<RouteArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    @JvmName("qrmhqemrysmwwsji")
    public suspend fun disableBgpRoutePropagation(`value`: Output<Boolean>) {
        this.disableBgpRoutePropagation = value
    }

    /**
     * @param value Gets a unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("esycwnlhwfoltrvx")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("eddupjhycseolneu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("iqsopccjuqaexpdi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("eteqomballvwhxlf")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Collection of routes contained within a route table.
     */
    @JvmName("vkkvfpeqordkgxac")
    public suspend fun routes(`value`: Output<List<RouteArgs>>) {
        this.routes = value
    }

    @JvmName("qbhyxarvcahljodc")
    public suspend fun routes(vararg values: Output<RouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Collection of routes contained within a route table.
     */
    @JvmName("enreyihbsogfomtg")
    public suspend fun routes(values: List<Output<RouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kiibnoojjrledpdg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether to disable the routes learned by BGP on that route table. True means disable.
     */
    @JvmName("gsfnhxdyajoegtfr")
    public suspend fun disableBgpRoutePropagation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableBgpRoutePropagation = mapped
    }

    /**
     * @param value Gets a unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("vkwhrcjqbsabrrko")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lmtrnsieqijnbirj")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ssfthnatwywuwoac")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
     */
    @JvmName("typkvvehgqfhwujw")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Collection of routes contained within a route table.
     */
    @JvmName("pwbntghydalcukbm")
    public suspend fun routes(`value`: List<RouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("mcvcwkmjsoajujjb")
    public suspend fun routes(argument: List<suspend RouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("oljpjgrdijlauyan")
    public suspend fun routes(vararg argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("fjbqchcmypjfftqc")
    public suspend fun routes(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Collection of routes contained within a route table.
     */
    @JvmName("scfmsbwpbvebqgkv")
    public suspend fun routes(vararg values: RouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("apryxaaibxhfxtwp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jxjehtmvylefuplq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        disableBgpRoutePropagation = disableBgpRoutePropagation,
        etag = etag,
        id = id,
        location = location,
        provisioningState = provisioningState,
        routes = routes,
        tags = tags,
    )
}
