@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RoutingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Routing Configuration indicating the associated and propagated route tables for this connection.
 * @property associatedRouteTable The resource id RouteTable associated with this RoutingConfiguration.
 * @property inboundRouteMap The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
 * @property outboundRouteMap The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
 * @property propagatedRouteTables The list of RouteTables to advertise the routes to.
 * @property vnetRoutes List of routes that control routing from VirtualHub into a virtual network connection.
 */
public data class RoutingConfigurationArgs(
    public val associatedRouteTable: Output<SubResourceArgs>? = null,
    public val inboundRouteMap: Output<SubResourceArgs>? = null,
    public val outboundRouteMap: Output<SubResourceArgs>? = null,
    public val propagatedRouteTables: Output<PropagatedRouteTableArgs>? = null,
    public val vnetRoutes: Output<VnetRouteArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RoutingConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RoutingConfigurationArgs =
        com.pulumi.azurenative.network.inputs.RoutingConfigurationArgs.builder()
            .associatedRouteTable(
                associatedRouteTable?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .inboundRouteMap(inboundRouteMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outboundRouteMap(outboundRouteMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .propagatedRouteTables(
                propagatedRouteTables?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vnetRoutes(vnetRoutes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RoutingConfigurationArgs].
 */
@PulumiTagMarker
public class RoutingConfigurationArgsBuilder internal constructor() {
    private var associatedRouteTable: Output<SubResourceArgs>? = null

    private var inboundRouteMap: Output<SubResourceArgs>? = null

    private var outboundRouteMap: Output<SubResourceArgs>? = null

    private var propagatedRouteTables: Output<PropagatedRouteTableArgs>? = null

    private var vnetRoutes: Output<VnetRouteArgs>? = null

    /**
     * @param value The resource id RouteTable associated with this RoutingConfiguration.
     */
    @JvmName("bfflmfwryqemknhy")
    public suspend fun associatedRouteTable(`value`: Output<SubResourceArgs>) {
        this.associatedRouteTable = value
    }

    /**
     * @param value The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
     */
    @JvmName("fymfmjviytmdkhsq")
    public suspend fun inboundRouteMap(`value`: Output<SubResourceArgs>) {
        this.inboundRouteMap = value
    }

    /**
     * @param value The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
     */
    @JvmName("injeurxkcirrddtr")
    public suspend fun outboundRouteMap(`value`: Output<SubResourceArgs>) {
        this.outboundRouteMap = value
    }

    /**
     * @param value The list of RouteTables to advertise the routes to.
     */
    @JvmName("nsuyxhqswnyymnml")
    public suspend fun propagatedRouteTables(`value`: Output<PropagatedRouteTableArgs>) {
        this.propagatedRouteTables = value
    }

    /**
     * @param value List of routes that control routing from VirtualHub into a virtual network connection.
     */
    @JvmName("qbutenbuktkmhrag")
    public suspend fun vnetRoutes(`value`: Output<VnetRouteArgs>) {
        this.vnetRoutes = value
    }

    /**
     * @param value The resource id RouteTable associated with this RoutingConfiguration.
     */
    @JvmName("cmgtggkeweefnrre")
    public suspend fun associatedRouteTable(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedRouteTable = mapped
    }

    /**
     * @param argument The resource id RouteTable associated with this RoutingConfiguration.
     */
    @JvmName("yocoyosopsgrrgww")
    public suspend fun associatedRouteTable(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.associatedRouteTable = mapped
    }

    /**
     * @param value The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
     */
    @JvmName("qufxniacfaqxftlk")
    public suspend fun inboundRouteMap(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundRouteMap = mapped
    }

    /**
     * @param argument The resource id of the RouteMap associated with this RoutingConfiguration for inbound learned routes.
     */
    @JvmName("tjqoioekgwusypso")
    public suspend fun inboundRouteMap(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inboundRouteMap = mapped
    }

    /**
     * @param value The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
     */
    @JvmName("iosdghjmvdfgkapc")
    public suspend fun outboundRouteMap(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundRouteMap = mapped
    }

    /**
     * @param argument The resource id of theRouteMap associated with this RoutingConfiguration for outbound advertised routes.
     */
    @JvmName("pslomxwshwawcqyw")
    public suspend fun outboundRouteMap(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.outboundRouteMap = mapped
    }

    /**
     * @param value The list of RouteTables to advertise the routes to.
     */
    @JvmName("hujtwowsywfwhenk")
    public suspend fun propagatedRouteTables(`value`: PropagatedRouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propagatedRouteTables = mapped
    }

    /**
     * @param argument The list of RouteTables to advertise the routes to.
     */
    @JvmName("ymgqyslegyeqxnyo")
    public suspend
    fun propagatedRouteTables(argument: suspend PropagatedRouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = PropagatedRouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.propagatedRouteTables = mapped
    }

    /**
     * @param value List of routes that control routing from VirtualHub into a virtual network connection.
     */
    @JvmName("flihfdoinbpcdrfs")
    public suspend fun vnetRoutes(`value`: VnetRouteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetRoutes = mapped
    }

    /**
     * @param argument List of routes that control routing from VirtualHub into a virtual network connection.
     */
    @JvmName("vnmmcefuhvedwtlv")
    public suspend fun vnetRoutes(argument: suspend VnetRouteArgsBuilder.() -> Unit) {
        val toBeMapped = VnetRouteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetRoutes = mapped
    }

    internal fun build(): RoutingConfigurationArgs = RoutingConfigurationArgs(
        associatedRouteTable = associatedRouteTable,
        inboundRouteMap = inboundRouteMap,
        outboundRouteMap = outboundRouteMap,
        propagatedRouteTables = propagatedRouteTables,
        vnetRoutes = vnetRoutes,
    )
}
