@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RulesEngineActionArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * One or more actions that will execute, modifying the request and/or response.
 * @property requestHeaderActions A list of header actions to apply from the request from AFD to the origin.
 * @property responseHeaderActions A list of header actions to apply from the response from AFD to the client.
 * @property routeConfigurationOverride Override the route configuration.
 */
public data class RulesEngineActionArgs(
    public val requestHeaderActions: Output<List<HeaderActionArgs>>? = null,
    public val responseHeaderActions: Output<List<HeaderActionArgs>>? = null,
    public val routeConfigurationOverride:
    Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RulesEngineActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RulesEngineActionArgs =
        com.pulumi.azurenative.network.inputs.RulesEngineActionArgs.builder()
            .requestHeaderActions(
                requestHeaderActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .responseHeaderActions(
                responseHeaderActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .routeConfigurationOverride(
                routeConfigurationOverride?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RulesEngineActionArgs].
 */
@PulumiTagMarker
public class RulesEngineActionArgsBuilder internal constructor() {
    private var requestHeaderActions: Output<List<HeaderActionArgs>>? = null

    private var responseHeaderActions: Output<List<HeaderActionArgs>>? = null

    private var routeConfigurationOverride:
        Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>? = null

    /**
     * @param value A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("hduxqbayujplvwio")
    public suspend fun requestHeaderActions(`value`: Output<List<HeaderActionArgs>>) {
        this.requestHeaderActions = value
    }

    @JvmName("ttdhhofcycqdkvqy")
    public suspend fun requestHeaderActions(vararg values: Output<HeaderActionArgs>) {
        this.requestHeaderActions = Output.all(values.asList())
    }

    /**
     * @param values A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("fysulfqkhllbmniq")
    public suspend fun requestHeaderActions(values: List<Output<HeaderActionArgs>>) {
        this.requestHeaderActions = Output.all(values)
    }

    /**
     * @param value A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("javbaqbqesjbmblu")
    public suspend fun responseHeaderActions(`value`: Output<List<HeaderActionArgs>>) {
        this.responseHeaderActions = value
    }

    @JvmName("mjhpiteicrndcfsb")
    public suspend fun responseHeaderActions(vararg values: Output<HeaderActionArgs>) {
        this.responseHeaderActions = Output.all(values.asList())
    }

    /**
     * @param values A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("gcbvxxumbdtxublw")
    public suspend fun responseHeaderActions(values: List<Output<HeaderActionArgs>>) {
        this.responseHeaderActions = Output.all(values)
    }

    /**
     * @param value Override the route configuration.
     */
    @JvmName("xbmhninfhggspqhk")
    public suspend
    fun routeConfigurationOverride(`value`: Output<Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>>) {
        this.routeConfigurationOverride = value
    }

    /**
     * @param value A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("slwwuxbdhcljnbhi")
    public suspend fun requestHeaderActions(`value`: List<HeaderActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("gerskgfundmkxyrp")
    public suspend
    fun requestHeaderActions(argument: List<suspend HeaderActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HeaderActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("mqwtffwxcquptycx")
    public suspend fun requestHeaderActions(
        vararg
        argument: suspend HeaderActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HeaderActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("llylwafnhffdrnci")
    public suspend fun requestHeaderActions(argument: suspend HeaderActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HeaderActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestHeaderActions = mapped
    }

    /**
     * @param values A list of header actions to apply from the request from AFD to the origin.
     */
    @JvmName("xnpxnuewbniqiket")
    public suspend fun requestHeaderActions(vararg values: HeaderActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestHeaderActions = mapped
    }

    /**
     * @param value A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("rsmhddybuxiaddlp")
    public suspend fun responseHeaderActions(`value`: List<HeaderActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("ptymmfndfdwdbjvm")
    public suspend
    fun responseHeaderActions(argument: List<suspend HeaderActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HeaderActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("lpfyowrkwyhhijcm")
    public suspend fun responseHeaderActions(
        vararg
        argument: suspend HeaderActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HeaderActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaderActions = mapped
    }

    /**
     * @param argument A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("tgysivqjhgsnedly")
    public suspend fun responseHeaderActions(argument: suspend HeaderActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HeaderActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.responseHeaderActions = mapped
    }

    /**
     * @param values A list of header actions to apply from the response from AFD to the client.
     */
    @JvmName("omhjhckwlhubhrvy")
    public suspend fun responseHeaderActions(vararg values: HeaderActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaderActions = mapped
    }

    /**
     * @param value Override the route configuration.
     */
    @JvmName("alnkcqclighdmkby")
    public suspend
    fun routeConfigurationOverride(`value`: Either<ForwardingConfigurationArgs, RedirectConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeConfigurationOverride = mapped
    }

    /**
     * @param value Override the route configuration.
     */
    @JvmName("riklcvfohvmvrvrq")
    public fun routeConfigurationOverride(`value`: ForwardingConfigurationArgs) {
        val toBeMapped = Either.ofLeft<ForwardingConfigurationArgs, RedirectConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeConfigurationOverride = mapped
    }

    /**
     * @param value Override the route configuration.
     */
    @JvmName("lfwpyuvtamuhcxsq")
    public fun routeConfigurationOverride(`value`: RedirectConfigurationArgs) {
        val toBeMapped = Either.ofRight<ForwardingConfigurationArgs, RedirectConfigurationArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeConfigurationOverride = mapped
    }

    internal fun build(): RulesEngineActionArgs = RulesEngineActionArgs(
        requestHeaderActions = requestHeaderActions,
        responseHeaderActions = responseHeaderActions,
        routeConfigurationOverride = routeConfigurationOverride,
    )
}
