@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.MatchProcessingBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
 * @property action Actions to perform on the request and response if all of the match conditions are met.
 * @property matchConditions A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
 * @property matchProcessingBehavior If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
 * @property name A name to refer to this specific rule.
 * @property priority A priority assigned to this rule.
 */
public data class RulesEngineRuleArgs(
    public val action: Output<RulesEngineActionArgs>,
    public val matchConditions: Output<List<RulesEngineMatchConditionArgs>>? = null,
    public val matchProcessingBehavior: Output<Either<String, MatchProcessingBehavior>>? = null,
    public val name: Output<String>,
    public val priority: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs =
        com.pulumi.azurenative.network.inputs.RulesEngineRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .matchConditions(
                matchConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchProcessingBehavior(
                matchProcessingBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RulesEngineRuleArgs].
 */
@PulumiTagMarker
public class RulesEngineRuleArgsBuilder internal constructor() {
    private var action: Output<RulesEngineActionArgs>? = null

    private var matchConditions: Output<List<RulesEngineMatchConditionArgs>>? = null

    private var matchProcessingBehavior: Output<Either<String, MatchProcessingBehavior>>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Actions to perform on the request and response if all of the match conditions are met.
     */
    @JvmName("xtmxyciwguoyvvhl")
    public suspend fun action(`value`: Output<RulesEngineActionArgs>) {
        this.action = value
    }

    /**
     * @param value A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("hbeydakkqlbaxjyk")
    public suspend fun matchConditions(`value`: Output<List<RulesEngineMatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("nxlsiyfdubalmffi")
    public suspend fun matchConditions(vararg values: Output<RulesEngineMatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("ghajvgkaedqhttbv")
    public suspend fun matchConditions(values: List<Output<RulesEngineMatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("pocnasrcpemqnjho")
    public suspend
    fun matchProcessingBehavior(`value`: Output<Either<String, MatchProcessingBehavior>>) {
        this.matchProcessingBehavior = value
    }

    /**
     * @param value A name to refer to this specific rule.
     */
    @JvmName("hkktsaklchidpval")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A priority assigned to this rule.
     */
    @JvmName("ancmluicwbgrvxdc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Actions to perform on the request and response if all of the match conditions are met.
     */
    @JvmName("brgexoulbfhqctvn")
    public suspend fun action(`value`: RulesEngineActionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Actions to perform on the request and response if all of the match conditions are met.
     */
    @JvmName("flbhcbmfntyxvyrh")
    public suspend fun action(argument: suspend RulesEngineActionArgsBuilder.() -> Unit) {
        val toBeMapped = RulesEngineActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("aqkwmagjeurmdrov")
    public suspend fun matchConditions(`value`: List<RulesEngineMatchConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("ywjmsjcguwxyabmv")
    public suspend
    fun matchConditions(argument: List<suspend RulesEngineMatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RulesEngineMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("oollhunyhkblnydc")
    public suspend fun matchConditions(
        vararg
        argument: suspend RulesEngineMatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RulesEngineMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("ytuequkljdvowkkh")
    public suspend
    fun matchConditions(argument: suspend RulesEngineMatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RulesEngineMatchConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
     */
    @JvmName("mnfkbgotnpbtetfw")
    public suspend fun matchConditions(vararg values: RulesEngineMatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("sdahflesishbnxvx")
    public suspend fun matchProcessingBehavior(`value`: Either<String, MatchProcessingBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("aygowgmxoxoqyefs")
    public fun matchProcessingBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MatchProcessingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("tlppokbdbgtloqrk")
    public fun matchProcessingBehavior(`value`: MatchProcessingBehavior) {
        val toBeMapped = Either.ofRight<String, MatchProcessingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value A name to refer to this specific rule.
     */
    @JvmName("pumycconlthbynpk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A priority assigned to this rule.
     */
    @JvmName("ksjmsreftbvwkxpa")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): RulesEngineRuleArgs = RulesEngineRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        matchConditions = matchConditions,
        matchProcessingBehavior = matchProcessingBehavior,
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority ?: throw PulumiNullFieldException("priority"),
    )
}
