@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.StaticRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * List of all Static Routes.
 * @property addressPrefixes List of all address prefixes.
 * @property name The name of the StaticRoute that is unique within a VnetRoute.
 * @property nextHopIpAddress The ip address of the next hop.
 */
public data class StaticRouteArgs(
    public val addressPrefixes: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val nextHopIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.StaticRouteArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.StaticRouteArgs =
        com.pulumi.azurenative.network.inputs.StaticRouteArgs.builder()
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StaticRouteArgs].
 */
@PulumiTagMarker
public class StaticRouteArgsBuilder internal constructor() {
    private var addressPrefixes: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var nextHopIpAddress: Output<String>? = null

    /**
     * @param value List of all address prefixes.
     */
    @JvmName("rxfxlemeamwxrawq")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("tbabilypbeiiliiw")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of all address prefixes.
     */
    @JvmName("jgtflfkcwavodhwi")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value The name of the StaticRoute that is unique within a VnetRoute.
     */
    @JvmName("enlcbatjpyfpeddx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ip address of the next hop.
     */
    @JvmName("nsrnhivotwdckovv")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value List of all address prefixes.
     */
    @JvmName("bmiotnksyllgykwk")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of all address prefixes.
     */
    @JvmName("wnilujwnpkxlqgwm")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value The name of the StaticRoute that is unique within a VnetRoute.
     */
    @JvmName("hwtiuqqfyfwlkcfm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ip address of the next hop.
     */
    @JvmName("ocueniebvimgnsbj")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    internal fun build(): StaticRouteArgs = StaticRouteArgs(
        addressPrefixes = addressPrefixes,
        name = name,
        nextHopIpAddress = nextHopIpAddress,
    )
}
