@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SubResource.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to a another resource
 * @property id Sub-resource ID. Both absolute resource ID and a relative resource ID are accepted.
 * An absolute ID starts with /subscriptions/ and contains the entire ID of the parent resource and the ID of the sub-resource in the end.
 * A relative ID replaces the ID of the parent resource with a token '$self', followed by the sub-resource ID itself.
 * Example of a relative ID: $self/frontEndConfigurations/my-frontend.
 */
public data class SubResource(
    public val id: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SubResource> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SubResource =
        com.pulumi.azurenative.network.inputs.SubResource.builder()
            .id(id?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [SubResource].
 */
@PulumiTagMarker
public class SubResourceBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Sub-resource ID. Both absolute resource ID and a relative resource ID are accepted.
     * An absolute ID starts with /subscriptions/ and contains the entire ID of the parent resource and the ID of the sub-resource in the end.
     * A relative ID replaces the ID of the parent resource with a token '$self', followed by the sub-resource ID itself.
     * Example of a relative ID: $self/frontEndConfigurations/my-frontend.
     */
    @JvmName("idrxacoynglbecro")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): SubResource = SubResource(
        id = id,
    )
}
