@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.SubnetArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateEndpointNetworkPolicies
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPrivateLinkServiceNetworkPolicies
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Subnet in a virtual network resource.
 * @property addressPrefix The address prefix for the subnet.
 * @property addressPrefixes List of address prefixes for the subnet.
 * @property applicationGatewayIPConfigurations Application gateway IP configurations of virtual network resource.
 * @property delegations An array of references to the delegations on the subnet.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this subnet.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natGateway Nat gateway associated with this subnet.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 * @property provisioningState The provisioning state of the resource.
 * @property resourceNavigationLinks Gets an array of references to the external resources using subnet.
 * @property routeTable The reference to the RouteTable resource.
 * @property serviceAssociationLinks Gets an array of references to services injecting into this subnet.
 * @property serviceEndpointPolicies An array of service endpoint policies.
 * @property serviceEndpoints An array of service endpoints.
 * @property type Resource type.
 */
public data class SubnetArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val applicationGatewayIPConfigurations:
    Output<List<ApplicationGatewayIPConfigurationArgs>>? = null,
    public val delegations: Output<List<DelegationArgs>>? = null,
    public val etag: Output<String>? = null,
    public val id: Output<String>? = null,
    public val ipAllocations: Output<List<SubResourceArgs>>? = null,
    public val name: Output<String>? = null,
    public val natGateway: Output<SubResourceArgs>? = null,
    public val networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null,
    public val privateEndpointNetworkPolicies:
    Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null,
    public val privateLinkServiceNetworkPolicies:
    Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceNavigationLinks: Output<List<ResourceNavigationLinkArgs>>? = null,
    public val routeTable: Output<RouteTableArgs>? = null,
    public val serviceAssociationLinks: Output<List<ServiceAssociationLinkArgs>>? = null,
    public val serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null,
    public val serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.SubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.SubnetArgs =
        com.pulumi.azurenative.network.inputs.SubnetArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .applicationGatewayIPConfigurations(
                applicationGatewayIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .delegations(
                delegations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .etag(etag?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipAllocations(
                ipAllocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateEndpointNetworkPolicies(
                privateEndpointNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .privateLinkServiceNetworkPolicies(
                privateLinkServiceNetworkPolicies?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceNavigationLinks(
                resourceNavigationLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceAssociationLinks(
                serviceAssociationLinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceEndpointPolicies(
                serviceEndpointPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceEndpoints(
                serviceEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetArgs].
 */
@PulumiTagMarker
public class SubnetArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var applicationGatewayIPConfigurations:
        Output<List<ApplicationGatewayIPConfigurationArgs>>? = null

    private var delegations: Output<List<DelegationArgs>>? = null

    private var etag: Output<String>? = null

    private var id: Output<String>? = null

    private var ipAllocations: Output<List<SubResourceArgs>>? = null

    private var name: Output<String>? = null

    private var natGateway: Output<SubResourceArgs>? = null

    private var networkSecurityGroup: Output<NetworkSecurityGroupArgs>? = null

    private var privateEndpointNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>? = null

    private var privateLinkServiceNetworkPolicies:
        Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>? = null

    private var provisioningState: Output<String>? = null

    private var resourceNavigationLinks: Output<List<ResourceNavigationLinkArgs>>? = null

    private var routeTable: Output<RouteTableArgs>? = null

    private var serviceAssociationLinks: Output<List<ServiceAssociationLinkArgs>>? = null

    private var serviceEndpointPolicies: Output<List<ServiceEndpointPolicyArgs>>? = null

    private var serviceEndpoints: Output<List<ServiceEndpointPropertiesFormatArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("lxnxvjowxyetgyls")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("joicjrgokrghbfau")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("ctjldopehbmgovph")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("grhcvbxtqhkvaoar")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("icnjrornthlbwvdl")
    public suspend
    fun applicationGatewayIPConfigurations(`value`: Output<List<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = value
    }

    @JvmName("awercarrcufauckb")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        values: Output<ApplicationGatewayIPConfigurationArgs>,
    ) {
        this.applicationGatewayIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("glisdmxdnssubqhr")
    public suspend
    fun applicationGatewayIPConfigurations(values: List<Output<ApplicationGatewayIPConfigurationArgs>>) {
        this.applicationGatewayIPConfigurations = Output.all(values)
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("sptujvjmhohgmeqr")
    public suspend fun delegations(`value`: Output<List<DelegationArgs>>) {
        this.delegations = value
    }

    @JvmName("jdaehqjqgotpgvkl")
    public suspend fun delegations(vararg values: Output<DelegationArgs>) {
        this.delegations = Output.all(values.asList())
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("vlmwxeqldixmeqfb")
    public suspend fun delegations(values: List<Output<DelegationArgs>>) {
        this.delegations = Output.all(values)
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("uvkcvhxbhodmsnwf")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lnpaqsdfkcnymiiv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("qwbvecpbpbuojtfc")
    public suspend fun ipAllocations(`value`: Output<List<SubResourceArgs>>) {
        this.ipAllocations = value
    }

    @JvmName("qvkblmogyrjidkao")
    public suspend fun ipAllocations(vararg values: Output<SubResourceArgs>) {
        this.ipAllocations = Output.all(values.asList())
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("mnunqljjohcxpoam")
    public suspend fun ipAllocations(values: List<Output<SubResourceArgs>>) {
        this.ipAllocations = Output.all(values)
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("kjfhymbhsccwepuo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("pryaecdiobaxxuty")
    public suspend fun natGateway(`value`: Output<SubResourceArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("xtspoxnuufljljnq")
    public suspend fun networkSecurityGroup(`value`: Output<NetworkSecurityGroupArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("yiqkfunsxxmrsuce")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>>) {
        this.privateEndpointNetworkPolicies = value
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("yvkipcvsdnghidvj")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Output<Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>>) {
        this.privateLinkServiceNetworkPolicies = value
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("eiyyusmgjmylgnyw")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value Gets an array of references to the external resources using subnet.
     */
    @JvmName("dbvrkqnmiulruqsl")
    public suspend fun resourceNavigationLinks(`value`: Output<List<ResourceNavigationLinkArgs>>) {
        this.resourceNavigationLinks = value
    }

    @JvmName("rxquggdokfuecxuq")
    public suspend fun resourceNavigationLinks(vararg values: Output<ResourceNavigationLinkArgs>) {
        this.resourceNavigationLinks = Output.all(values.asList())
    }

    /**
     * @param values Gets an array of references to the external resources using subnet.
     */
    @JvmName("bewgbmpyilovrkxx")
    public suspend fun resourceNavigationLinks(values: List<Output<ResourceNavigationLinkArgs>>) {
        this.resourceNavigationLinks = Output.all(values)
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("blbegbvaqahohwpm")
    public suspend fun routeTable(`value`: Output<RouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value Gets an array of references to services injecting into this subnet.
     */
    @JvmName("hmaolpftrkwqoqoy")
    public suspend fun serviceAssociationLinks(`value`: Output<List<ServiceAssociationLinkArgs>>) {
        this.serviceAssociationLinks = value
    }

    @JvmName("rlhvxdsexkavfyml")
    public suspend fun serviceAssociationLinks(vararg values: Output<ServiceAssociationLinkArgs>) {
        this.serviceAssociationLinks = Output.all(values.asList())
    }

    /**
     * @param values Gets an array of references to services injecting into this subnet.
     */
    @JvmName("uepdyugtloopekfo")
    public suspend fun serviceAssociationLinks(values: List<Output<ServiceAssociationLinkArgs>>) {
        this.serviceAssociationLinks = Output.all(values)
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("yujitfeowtvfpivt")
    public suspend fun serviceEndpointPolicies(`value`: Output<List<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = value
    }

    @JvmName("dtxccfyqteibache")
    public suspend fun serviceEndpointPolicies(vararg values: Output<ServiceEndpointPolicyArgs>) {
        this.serviceEndpointPolicies = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("vbfdktmqwmpsmevr")
    public suspend fun serviceEndpointPolicies(values: List<Output<ServiceEndpointPolicyArgs>>) {
        this.serviceEndpointPolicies = Output.all(values)
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("ukagiighxxdorbyx")
    public suspend fun serviceEndpoints(`value`: Output<List<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = value
    }

    @JvmName("fshqjsqbssuwvlkf")
    public suspend fun serviceEndpoints(vararg values: Output<ServiceEndpointPropertiesFormatArgs>) {
        this.serviceEndpoints = Output.all(values.asList())
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("thckhoxksmvvvupj")
    public suspend fun serviceEndpoints(values: List<Output<ServiceEndpointPropertiesFormatArgs>>) {
        this.serviceEndpoints = Output.all(values)
    }

    /**
     * @param value Resource type.
     */
    @JvmName("vayewvitobhqaspn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The address prefix for the subnet.
     */
    @JvmName("dntvutrteijagwus")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value List of address prefixes for the subnet.
     */
    @JvmName("orgrqipiaeilechd")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values List of address prefixes for the subnet.
     */
    @JvmName("sfnsomksvydncokx")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value Application gateway IP configurations of virtual network resource.
     */
    @JvmName("hdjqvfxarkddfisq")
    public suspend
    fun applicationGatewayIPConfigurations(`value`: List<ApplicationGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("noyacccowtnxhpng")
    public suspend
    fun applicationGatewayIPConfigurations(argument: List<suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("fhoibtkwdijjadin")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param argument Application gateway IP configurations of virtual network resource.
     */
    @JvmName("wwcoaqukcwpqjhny")
    public suspend
    fun applicationGatewayIPConfigurations(argument: suspend ApplicationGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param values Application gateway IP configurations of virtual network resource.
     */
    @JvmName("yqoejwebcbybtnpu")
    public suspend fun applicationGatewayIPConfigurations(
        vararg
        values: ApplicationGatewayIPConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGatewayIPConfigurations = mapped
    }

    /**
     * @param value An array of references to the delegations on the subnet.
     */
    @JvmName("mnimeuxoaudxbgvk")
    public suspend fun delegations(`value`: List<DelegationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("jqmkfxrnfetxstno")
    public suspend fun delegations(argument: List<suspend DelegationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("ufagcypjswgfhaxw")
    public suspend fun delegations(vararg argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DelegationArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param argument An array of references to the delegations on the subnet.
     */
    @JvmName("phweotoecvrgmtxs")
    public suspend fun delegations(argument: suspend DelegationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DelegationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.delegations = mapped
    }

    /**
     * @param values An array of references to the delegations on the subnet.
     */
    @JvmName("uuluxheugbodixsk")
    public suspend fun delegations(vararg values: DelegationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.delegations = mapped
    }

    /**
     * @param value A unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("kphhcnhnwlrpopbx")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yjnmmihqweelqpft")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Array of IpAllocation which reference this subnet.
     */
    @JvmName("uehsjpienytxokdx")
    public suspend fun ipAllocations(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("xuydyxlshhymbltm")
    public suspend fun ipAllocations(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("vhejwgmacnxgelix")
    public suspend fun ipAllocations(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param argument Array of IpAllocation which reference this subnet.
     */
    @JvmName("axovijtslnkylpbf")
    public suspend fun ipAllocations(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipAllocations = mapped
    }

    /**
     * @param values Array of IpAllocation which reference this subnet.
     */
    @JvmName("hlraoqeyijtfhvod")
    public suspend fun ipAllocations(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocations = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("nkhurreelchmgkqw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Nat gateway associated with this subnet.
     */
    @JvmName("irngrlbkmgeaonpt")
    public suspend fun natGateway(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument Nat gateway associated with this subnet.
     */
    @JvmName("mylirougxheukjte")
    public suspend fun natGateway(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("hhmgwgpeitymvmbx")
    public suspend fun networkSecurityGroup(`value`: NetworkSecurityGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument The reference to the NetworkSecurityGroup resource.
     */
    @JvmName("aikrbqbyrblgbjrn")
    public suspend
    fun networkSecurityGroup(argument: suspend NetworkSecurityGroupArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkSecurityGroupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("yyjrbtpxiarhxdky")
    public suspend
    fun privateEndpointNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateEndpointNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("judpnvunpdqmiinb")
    public fun privateEndpointNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private end point in the subnet.
     */
    @JvmName("kmeswjksjmyuuyyl")
    public fun privateEndpointNetworkPolicies(`value`: VirtualNetworkPrivateEndpointNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateEndpointNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("mpjjmnepbicydgwy")
    public suspend
    fun privateLinkServiceNetworkPolicies(`value`: Either<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("dlsycyuefpihftgb")
    public fun privateLinkServiceNetworkPolicies(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value Enable or Disable apply network policies on private link service in the subnet.
     */
    @JvmName("ddunkwggtrdxhahf")
    public
    fun privateLinkServiceNetworkPolicies(`value`: VirtualNetworkPrivateLinkServiceNetworkPolicies) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPrivateLinkServiceNetworkPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceNetworkPolicies = mapped
    }

    /**
     * @param value The provisioning state of the resource.
     */
    @JvmName("uuiehcrrmavysymk")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Gets an array of references to the external resources using subnet.
     */
    @JvmName("btjerjiqhhrstyas")
    public suspend fun resourceNavigationLinks(`value`: List<ResourceNavigationLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("nhmvygmxkknrbagt")
    public suspend
    fun resourceNavigationLinks(argument: List<suspend ResourceNavigationLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceNavigationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("japmahirlvudikxn")
    public suspend fun resourceNavigationLinks(
        vararg
        argument: suspend ResourceNavigationLinkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceNavigationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to the external resources using subnet.
     */
    @JvmName("exckfmbtyyxjgwjw")
    public suspend
    fun resourceNavigationLinks(argument: suspend ResourceNavigationLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceNavigationLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param values Gets an array of references to the external resources using subnet.
     */
    @JvmName("jourbfelsaewhfsk")
    public suspend fun resourceNavigationLinks(vararg values: ResourceNavigationLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceNavigationLinks = mapped
    }

    /**
     * @param value The reference to the RouteTable resource.
     */
    @JvmName("iypuncwiloldewfv")
    public suspend fun routeTable(`value`: RouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument The reference to the RouteTable resource.
     */
    @JvmName("pcacmwqusxoeinoi")
    public suspend fun routeTable(argument: suspend RouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = RouteTableArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value Gets an array of references to services injecting into this subnet.
     */
    @JvmName("jmvjxomrnyklibct")
    public suspend fun serviceAssociationLinks(`value`: List<ServiceAssociationLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("rgxioyhlymyjawkb")
    public suspend
    fun serviceAssociationLinks(argument: List<suspend ServiceAssociationLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceAssociationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("bavghvclstaqdcpv")
    public suspend fun serviceAssociationLinks(
        vararg
        argument: suspend ServiceAssociationLinkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceAssociationLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param argument Gets an array of references to services injecting into this subnet.
     */
    @JvmName("uyoqbswxoftapaii")
    public suspend
    fun serviceAssociationLinks(argument: suspend ServiceAssociationLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceAssociationLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param values Gets an array of references to services injecting into this subnet.
     */
    @JvmName("rvnaysocsvuvtwvl")
    public suspend fun serviceAssociationLinks(vararg values: ServiceAssociationLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceAssociationLinks = mapped
    }

    /**
     * @param value An array of service endpoint policies.
     */
    @JvmName("kfwgoghyeuudvdhx")
    public suspend fun serviceEndpointPolicies(`value`: List<ServiceEndpointPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("sacwcybqypltpoyu")
    public suspend
    fun serviceEndpointPolicies(argument: List<suspend ServiceEndpointPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("ejquuoxhitamgisk")
    public suspend fun serviceEndpointPolicies(
        vararg
        argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param argument An array of service endpoint policies.
     */
    @JvmName("cgiwddmwiuqtiyrm")
    public suspend
    fun serviceEndpointPolicies(argument: suspend ServiceEndpointPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceEndpointPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param values An array of service endpoint policies.
     */
    @JvmName("gvckqgdvtxnylohk")
    public suspend fun serviceEndpointPolicies(vararg values: ServiceEndpointPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpointPolicies = mapped
    }

    /**
     * @param value An array of service endpoints.
     */
    @JvmName("iogwabyncsdsypvo")
    public suspend fun serviceEndpoints(`value`: List<ServiceEndpointPropertiesFormatArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("qbmmwruodusexrfv")
    public suspend
    fun serviceEndpoints(argument: List<suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("ulssjeunctocjale")
    public suspend fun serviceEndpoints(
        vararg
        argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param argument An array of service endpoints.
     */
    @JvmName("pkubwtlyqaqbcjsb")
    public suspend
    fun serviceEndpoints(argument: suspend ServiceEndpointPropertiesFormatArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceEndpointPropertiesFormatArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceEndpoints = mapped
    }

    /**
     * @param values An array of service endpoints.
     */
    @JvmName("nfvcmbfnhkyuphpr")
    public suspend fun serviceEndpoints(vararg values: ServiceEndpointPropertiesFormatArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("ohjdhcpaijrbqytj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SubnetArgs = SubnetArgs(
        addressPrefix = addressPrefix,
        addressPrefixes = addressPrefixes,
        applicationGatewayIPConfigurations = applicationGatewayIPConfigurations,
        delegations = delegations,
        etag = etag,
        id = id,
        ipAllocations = ipAllocations,
        name = name,
        natGateway = natGateway,
        networkSecurityGroup = networkSecurityGroup,
        privateEndpointNetworkPolicies = privateEndpointNetworkPolicies,
        privateLinkServiceNetworkPolicies = privateLinkServiceNetworkPolicies,
        provisioningState = provisioningState,
        resourceNavigationLinks = resourceNavigationLinks,
        routeTable = routeTable,
        serviceAssociationLinks = serviceAssociationLinks,
        serviceEndpointPolicies = serviceEndpointPolicies,
        serviceEndpoints = serviceEndpoints,
        type = type,
    )
}
