@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.TargetDnsServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a server to forward the DNS queries to.
 * @property ipAddress DNS server IP address.
 * @property port DNS server port.
 */
public data class TargetDnsServerArgs(
    public val ipAddress: Output<String>,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.TargetDnsServerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.TargetDnsServerArgs =
        com.pulumi.azurenative.network.inputs.TargetDnsServerArgs.builder()
            .ipAddress(ipAddress.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetDnsServerArgs].
 */
@PulumiTagMarker
public class TargetDnsServerArgsBuilder internal constructor() {
    private var ipAddress: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value DNS server IP address.
     */
    @JvmName("sewsopvuviukbolv")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value DNS server port.
     */
    @JvmName("vuxijmeyqtehbgng")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value DNS server IP address.
     */
    @JvmName("xflhqtndfygwybsb")
    public suspend fun ipAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value DNS server port.
     */
    @JvmName("vgbiawhyapjjumof")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): TargetDnsServerArgs = TargetDnsServerArgs(
        ipAddress = ipAddress ?: throw PulumiNullFieldException("ipAddress"),
        port = port,
    )
}
