@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualHubIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Hub identifier.
 * @property id The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
 */
public data class VirtualHubIdArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualHubIdArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualHubIdArgs =
        com.pulumi.azurenative.network.inputs.VirtualHubIdArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHubIdArgs].
 */
@PulumiTagMarker
public class VirtualHubIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
     */
    @JvmName("epgrqhrawntcbsgg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
     */
    @JvmName("lyojarfvprxyexqp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualHubIdArgs = VirtualHubIdArgs(
        id = id,
    )
}
