@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayNatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleMode
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualNetworkGatewayNatRule Resource.
 * @property externalMappings The private IP address external mapping for NAT.
 * @property id Resource ID.
 * @property internalMappings The private IP address internal mapping for NAT.
 * @property ipConfigurationId The IP Configuration ID this NAT rule applies to.
 * @property mode The Source NAT direction of a VPN NAT.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property type The type of NAT rule for VPN NAT.
 */
public data class VirtualNetworkGatewayNatRuleArgs(
    public val externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val id: Output<String>? = null,
    public val internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val ipConfigurationId: Output<String>? = null,
    public val mode: Output<Either<String, VpnNatRuleMode>>? = null,
    public val name: Output<String>? = null,
    public val type: Output<Either<String, VpnNatRuleType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayNatRuleArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayNatRuleArgs.builder()
            .externalMappings(
                externalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .internalMappings(
                internalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipConfigurationId(ipConfigurationId?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewayNatRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayNatRuleArgsBuilder internal constructor() {
    private var externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var id: Output<String>? = null

    private var internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var ipConfigurationId: Output<String>? = null

    private var mode: Output<Either<String, VpnNatRuleMode>>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, VpnNatRuleType>>? = null

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("ypfiisqphhpimquc")
    public suspend fun externalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.externalMappings = value
    }

    @JvmName("eqwfgrwiifjbifsb")
    public suspend fun externalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.externalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("noodetefknssieit")
    public suspend fun externalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.externalMappings = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mikmaflhsulaqkmi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("jvvmxblnmhhynerq")
    public suspend fun internalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.internalMappings = value
    }

    @JvmName("yfnhpfnmxjqvpubg")
    public suspend fun internalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.internalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("bvamclpkodmnblrk")
    public suspend fun internalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.internalMappings = Output.all(values)
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("mnfhnqyvkkteqsip")
    public suspend fun ipConfigurationId(`value`: Output<String>) {
        this.ipConfigurationId = value
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("wsxvgqjcelsbsbpe")
    public suspend fun mode(`value`: Output<Either<String, VpnNatRuleMode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qxxueocufqiinaal")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("pdubhtvgkborgsty")
    public suspend fun type(`value`: Output<Either<String, VpnNatRuleType>>) {
        this.type = value
    }

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("bjfeuebcfiscdsbr")
    public suspend fun externalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("tnckmlxmausanonm")
    public suspend
    fun externalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("ewhbfnacgjvqburj")
    public suspend fun externalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("jylyblcawlvsdgiq")
    public suspend fun externalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("cdvqsqxngpgcpdrl")
    public suspend fun externalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("poltrkmckbsifihw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("sxgwhtnlvafvrayo")
    public suspend fun internalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("ejqvwemupnofedcu")
    public suspend
    fun internalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("laprthhqjfyhcnhp")
    public suspend fun internalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("aemmkerpvyiyogvk")
    public suspend fun internalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("thbbjydhyfsqgaty")
    public suspend fun internalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("gysjuyudndkpskrc")
    public suspend fun ipConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurationId = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("ihautgywlignjtcs")
    public suspend fun mode(`value`: Either<String, VpnNatRuleMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("pjjgwsochmmaohsq")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("qfxbehgkppefnfcp")
    public fun mode(`value`: VpnNatRuleMode) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ondcorgvewpnmiao")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("bblqvibcftbqjdld")
    public suspend fun type(`value`: Either<String, VpnNatRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("bfehdwwuwplhudxo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("jfiecqxxagsrnorc")
    public fun type(`value`: VpnNatRuleType) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VirtualNetworkGatewayNatRuleArgs = VirtualNetworkGatewayNatRuleArgs(
        externalMappings = externalMappings,
        id = id,
        internalMappings = internalMappings,
        ipConfigurationId = ipConfigurationId,
        mode = mode,
        name = name,
        type = type,
    )
}
