@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupMemberArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnPolicyMemberAttributeType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Vpn Client Connection configuration PolicyGroup member
 * @property attributeType The Vpn Policy member attribute type.
 * @property attributeValue The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
 * @property name Name of the VirtualNetworkGatewayPolicyGroupMember.
 */
public data class VirtualNetworkGatewayPolicyGroupMemberArgs(
    public val attributeType: Output<Either<String, VpnPolicyMemberAttributeType>>? = null,
    public val attributeValue: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupMemberArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupMemberArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkGatewayPolicyGroupMemberArgs.builder()
            .attributeType(
                attributeType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .attributeValue(attributeValue?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkGatewayPolicyGroupMemberArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayPolicyGroupMemberArgsBuilder internal constructor() {
    private var attributeType: Output<Either<String, VpnPolicyMemberAttributeType>>? = null

    private var attributeValue: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("liahdtkqhybrhafc")
    public suspend fun attributeType(`value`: Output<Either<String, VpnPolicyMemberAttributeType>>) {
        this.attributeType = value
    }

    /**
     * @param value The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
     */
    @JvmName("eqbnrdoejfkliybh")
    public suspend fun attributeValue(`value`: Output<String>) {
        this.attributeValue = value
    }

    /**
     * @param value Name of the VirtualNetworkGatewayPolicyGroupMember.
     */
    @JvmName("pokiwaueolsbtovt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("aqxyoewsgenmlpqa")
    public suspend fun attributeType(`value`: Either<String, VpnPolicyMemberAttributeType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("jubodbmgstxvqnaa")
    public fun attributeType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnPolicyMemberAttributeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The Vpn Policy member attribute type.
     */
    @JvmName("dryqfvtclqnnatno")
    public fun attributeType(`value`: VpnPolicyMemberAttributeType) {
        val toBeMapped = Either.ofRight<String, VpnPolicyMemberAttributeType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeType = mapped
    }

    /**
     * @param value The value of Attribute used for this VirtualNetworkGatewayPolicyGroupMember.
     */
    @JvmName("uhaxlwxgdgnxdnva")
    public suspend fun attributeValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeValue = mapped
    }

    /**
     * @param value Name of the VirtualNetworkGatewayPolicyGroupMember.
     */
    @JvmName("jefngffbqonyrfqy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): VirtualNetworkGatewayPolicyGroupMemberArgs =
        VirtualNetworkGatewayPolicyGroupMemberArgs(
            attributeType = attributeType,
            attributeValue = attributeValue,
            name = name,
        )
}
