@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VirtualNetworkPeeringArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPeeringLevel
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkPeeringState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Peerings in a virtual network resource.
 * @property allowForwardedTraffic Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
 * @property allowGatewayTransit If gateway links can be used in remote virtual networking to link to this virtual network.
 * @property allowVirtualNetworkAccess Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
 * @property doNotVerifyRemoteGateways If we need to verify the provisioning state of the remote gateway.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peeringState The status of the virtual network peering.
 * @property peeringSyncLevel The peering sync status of the virtual network peering.
 * @property remoteAddressSpace The reference to the address space peered with the remote virtual network.
 * @property remoteBgpCommunities The reference to the remote virtual network's Bgp Communities.
 * @property remoteVirtualNetwork The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
 * @property remoteVirtualNetworkAddressSpace The reference to the current address space of the remote virtual network.
 * @property type Resource type.
 * @property useRemoteGateways If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
 */
public data class VirtualNetworkPeeringArgs(
    public val allowForwardedTraffic: Output<Boolean>? = null,
    public val allowGatewayTransit: Output<Boolean>? = null,
    public val allowVirtualNetworkAccess: Output<Boolean>? = null,
    public val doNotVerifyRemoteGateways: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val peeringState: Output<Either<String, VirtualNetworkPeeringState>>? = null,
    public val peeringSyncLevel: Output<Either<String, VirtualNetworkPeeringLevel>>? = null,
    public val remoteAddressSpace: Output<AddressSpaceArgs>? = null,
    public val remoteBgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null,
    public val remoteVirtualNetwork: Output<SubResourceArgs>? = null,
    public val remoteVirtualNetworkAddressSpace: Output<AddressSpaceArgs>? = null,
    public val type: Output<String>? = null,
    public val useRemoteGateways: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VirtualNetworkPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VirtualNetworkPeeringArgs =
        com.pulumi.azurenative.network.inputs.VirtualNetworkPeeringArgs.builder()
            .allowForwardedTraffic(allowForwardedTraffic?.applyValue({ args0 -> args0 }))
            .allowGatewayTransit(allowGatewayTransit?.applyValue({ args0 -> args0 }))
            .allowVirtualNetworkAccess(allowVirtualNetworkAccess?.applyValue({ args0 -> args0 }))
            .doNotVerifyRemoteGateways(doNotVerifyRemoteGateways?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .peeringState(
                peeringState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .peeringSyncLevel(
                peeringSyncLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .remoteAddressSpace(
                remoteAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteBgpCommunities(
                remoteBgpCommunities?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteVirtualNetwork(
                remoteVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteVirtualNetworkAddressSpace(
                remoteVirtualNetworkAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .type(type?.applyValue({ args0 -> args0 }))
            .useRemoteGateways(useRemoteGateways?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPeeringArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPeeringArgsBuilder internal constructor() {
    private var allowForwardedTraffic: Output<Boolean>? = null

    private var allowGatewayTransit: Output<Boolean>? = null

    private var allowVirtualNetworkAccess: Output<Boolean>? = null

    private var doNotVerifyRemoteGateways: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var peeringState: Output<Either<String, VirtualNetworkPeeringState>>? = null

    private var peeringSyncLevel: Output<Either<String, VirtualNetworkPeeringLevel>>? = null

    private var remoteAddressSpace: Output<AddressSpaceArgs>? = null

    private var remoteBgpCommunities: Output<VirtualNetworkBgpCommunitiesArgs>? = null

    private var remoteVirtualNetwork: Output<SubResourceArgs>? = null

    private var remoteVirtualNetworkAddressSpace: Output<AddressSpaceArgs>? = null

    private var type: Output<String>? = null

    private var useRemoteGateways: Output<Boolean>? = null

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("eqdawiquxmhvfpqt")
    public suspend fun allowForwardedTraffic(`value`: Output<Boolean>) {
        this.allowForwardedTraffic = value
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("oamsbhquaielhrqg")
    public suspend fun allowGatewayTransit(`value`: Output<Boolean>) {
        this.allowGatewayTransit = value
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("qypepkrvplgocois")
    public suspend fun allowVirtualNetworkAccess(`value`: Output<Boolean>) {
        this.allowVirtualNetworkAccess = value
    }

    /**
     * @param value If we need to verify the provisioning state of the remote gateway.
     */
    @JvmName("fdawgytmynnoflit")
    public suspend fun doNotVerifyRemoteGateways(`value`: Output<Boolean>) {
        this.doNotVerifyRemoteGateways = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("osqsvoonfxtwexib")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ibpjpndfaghojxoj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("ulvtaigjcyqiiklk")
    public suspend fun peeringState(`value`: Output<Either<String, VirtualNetworkPeeringState>>) {
        this.peeringState = value
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("ctqaqtrbxwfkffck")
    public suspend fun peeringSyncLevel(`value`: Output<Either<String, VirtualNetworkPeeringLevel>>) {
        this.peeringSyncLevel = value
    }

    /**
     * @param value The reference to the address space peered with the remote virtual network.
     */
    @JvmName("bspvfhhnywxwckjb")
    public suspend fun remoteAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.remoteAddressSpace = value
    }

    /**
     * @param value The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("uvxttacrnnnavtgw")
    public suspend fun remoteBgpCommunities(`value`: Output<VirtualNetworkBgpCommunitiesArgs>) {
        this.remoteBgpCommunities = value
    }

    /**
     * @param value The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("cmbursyakryyrldf")
    public suspend fun remoteVirtualNetwork(`value`: Output<SubResourceArgs>) {
        this.remoteVirtualNetwork = value
    }

    /**
     * @param value The reference to the current address space of the remote virtual network.
     */
    @JvmName("vgsnsvtnxjfumtpi")
    public suspend fun remoteVirtualNetworkAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.remoteVirtualNetworkAddressSpace = value
    }

    /**
     * @param value Resource type.
     */
    @JvmName("heuvhhiggavftdts")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("hxdiisuvyongjhmy")
    public suspend fun useRemoteGateways(`value`: Output<Boolean>) {
        this.useRemoteGateways = value
    }

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("mcdwsqajwnuxoule")
    public suspend fun allowForwardedTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForwardedTraffic = mapped
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("humcfmkbdtfgepyf")
    public suspend fun allowGatewayTransit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowGatewayTransit = mapped
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("wycjkvaobouncshj")
    public suspend fun allowVirtualNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVirtualNetworkAccess = mapped
    }

    /**
     * @param value If we need to verify the provisioning state of the remote gateway.
     */
    @JvmName("xmceuqwaacqihlgy")
    public suspend fun doNotVerifyRemoteGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doNotVerifyRemoteGateways = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("menxklawbffjabpb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("sswytbfwscwoelrp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("pedmtrophumepbmn")
    public suspend fun peeringState(`value`: Either<String, VirtualNetworkPeeringState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("avjcyiojblamnvqr")
    public fun peeringState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The status of the virtual network peering.
     */
    @JvmName("lypjtothsiyjotad")
    public fun peeringState(`value`: VirtualNetworkPeeringState) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPeeringState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringState = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("caiguxltcpnsiwhx")
    public suspend fun peeringSyncLevel(`value`: Either<String, VirtualNetworkPeeringLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("xjhhtwfvuxyajlxt")
    public fun peeringSyncLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkPeeringLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The peering sync status of the virtual network peering.
     */
    @JvmName("tccacveiacpfbcey")
    public fun peeringSyncLevel(`value`: VirtualNetworkPeeringLevel) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkPeeringLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peeringSyncLevel = mapped
    }

    /**
     * @param value The reference to the address space peered with the remote virtual network.
     */
    @JvmName("sdqmskkjjqawqsyg")
    public suspend fun remoteAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteAddressSpace = mapped
    }

    /**
     * @param argument The reference to the address space peered with the remote virtual network.
     */
    @JvmName("hthpladgxtumjwnn")
    public suspend fun remoteAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteAddressSpace = mapped
    }

    /**
     * @param value The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("mixcgtmdnhxiccpf")
    public suspend fun remoteBgpCommunities(`value`: VirtualNetworkBgpCommunitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteBgpCommunities = mapped
    }

    /**
     * @param argument The reference to the remote virtual network's Bgp Communities.
     */
    @JvmName("ixtmfkojmnjbipmw")
    public suspend
    fun remoteBgpCommunities(argument: suspend VirtualNetworkBgpCommunitiesArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkBgpCommunitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteBgpCommunities = mapped
    }

    /**
     * @param value The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("plxebwlnnpivuwxf")
    public suspend fun remoteVirtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param argument The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
     */
    @JvmName("yruypoqenhmuoxae")
    public suspend fun remoteVirtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param value The reference to the current address space of the remote virtual network.
     */
    @JvmName("njteinbnuqyhppdq")
    public suspend fun remoteVirtualNetworkAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetworkAddressSpace = mapped
    }

    /**
     * @param argument The reference to the current address space of the remote virtual network.
     */
    @JvmName("enlnqixpltxrfxwj")
    public suspend
    fun remoteVirtualNetworkAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetworkAddressSpace = mapped
    }

    /**
     * @param value Resource type.
     */
    @JvmName("obdtbhwhiociywpf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("ubokxauxssnkxbce")
    public suspend fun useRemoteGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useRemoteGateways = mapped
    }

    internal fun build(): VirtualNetworkPeeringArgs = VirtualNetworkPeeringArgs(
        allowForwardedTraffic = allowForwardedTraffic,
        allowGatewayTransit = allowGatewayTransit,
        allowVirtualNetworkAccess = allowVirtualNetworkAccess,
        doNotVerifyRemoteGateways = doNotVerifyRemoteGateways,
        id = id,
        name = name,
        peeringState = peeringState,
        peeringSyncLevel = peeringSyncLevel,
        remoteAddressSpace = remoteAddressSpace,
        remoteBgpCommunities = remoteBgpCommunities,
        remoteVirtualNetwork = remoteVirtualNetwork,
        remoteVirtualNetworkAddressSpace = remoteVirtualNetworkAddressSpace,
        type = type,
        useRemoteGateways = useRemoteGateways,
    )
}
