@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnAuthenticationType
import com.pulumi.azurenative.network.kotlin.enums.VpnClientProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnClientConfiguration for P2S client.
 * @property aadAudience The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadIssuer The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property aadTenant The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
 * @property radiusServerAddress The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServerSecret The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
 * @property radiusServers The radiusServers property for multiple radius server configuration.
 * @property vngClientConnectionConfigurations per ip address pool connection policy for virtual network gateway P2S client.
 * @property vpnAuthenticationTypes VPN authentication types for the virtual network gateway..
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for virtual network gateway P2S client.
 * @property vpnClientProtocols VpnClientProtocols for Virtual network gateway.
 * @property vpnClientRevokedCertificates VpnClientRevokedCertificate for Virtual network gateway.
 * @property vpnClientRootCertificates VpnClientRootCertificate for virtual network gateway.
 */
public data class VpnClientConfigurationArgs(
    public val aadAudience: Output<String>? = null,
    public val aadIssuer: Output<String>? = null,
    public val aadTenant: Output<String>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val radiusServers: Output<List<RadiusServerArgs>>? = null,
    public val vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null,
    public val vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null,
    public val vpnClientAddressPool: Output<AddressSpaceArgs>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null,
    public val vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null,
    public val vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs =
        com.pulumi.azurenative.network.inputs.VpnClientConfigurationArgs.builder()
            .aadAudience(aadAudience?.applyValue({ args0 -> args0 }))
            .aadIssuer(aadIssuer?.applyValue({ args0 -> args0 }))
            .aadTenant(aadTenant?.applyValue({ args0 -> args0 }))
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .radiusServers(
                radiusServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vngClientConnectionConfigurations(
                vngClientConnectionConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnAuthenticationTypes(
                vpnAuthenticationTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientAddressPool(
                vpnClientAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnClientProtocols(
                vpnClientProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientRevokedCertificates(
                vpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientRootCertificates(
                vpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VpnClientConfigurationArgs].
 */
@PulumiTagMarker
public class VpnClientConfigurationArgsBuilder internal constructor() {
    private var aadAudience: Output<String>? = null

    private var aadIssuer: Output<String>? = null

    private var aadTenant: Output<String>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerSecret: Output<String>? = null

    private var radiusServers: Output<List<RadiusServerArgs>>? = null

    private var vngClientConnectionConfigurations: Output<List<VngClientConnectionConfigurationArgs>>? =
        null

    private var vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null

    private var vpnClientAddressPool: Output<AddressSpaceArgs>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnClientProtocols: Output<List<Either<String, VpnClientProtocol>>>? = null

    private var vpnClientRevokedCertificates: Output<List<VpnClientRevokedCertificateArgs>>? = null

    private var vpnClientRootCertificates: Output<List<VpnClientRootCertificateArgs>>? = null

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("ajqjasatfhuivqnt")
    public suspend fun aadAudience(`value`: Output<String>) {
        this.aadAudience = value
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("wmhcvvcqjqvehoxm")
    public suspend fun aadIssuer(`value`: Output<String>) {
        this.aadIssuer = value
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("pnfnbpyyckrxfish")
    public suspend fun aadTenant(`value`: Output<String>) {
        this.aadTenant = value
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("gjxmncolocyfnpad")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("rvkufhkwjkykmver")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("mrhgaximvepwtayy")
    public suspend fun radiusServers(`value`: Output<List<RadiusServerArgs>>) {
        this.radiusServers = value
    }

    @JvmName("hoopcwyqeafpaflv")
    public suspend fun radiusServers(vararg values: Output<RadiusServerArgs>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("ccjsfjcjshprlqgq")
    public suspend fun radiusServers(values: List<Output<RadiusServerArgs>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("divomtoymogpjoln")
    public suspend
    fun vngClientConnectionConfigurations(`value`: Output<List<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = value
    }

    @JvmName("umrstonadwlrlkcs")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        values: Output<VngClientConnectionConfigurationArgs>,
    ) {
        this.vngClientConnectionConfigurations = Output.all(values.asList())
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("hynwevvmodkhdqfm")
    public suspend
    fun vngClientConnectionConfigurations(values: List<Output<VngClientConnectionConfigurationArgs>>) {
        this.vngClientConnectionConfigurations = Output.all(values)
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("nwkdrgbjukjqbhhm")
    public suspend
    fun vpnAuthenticationTypes(`value`: Output<List<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = value
    }

    @JvmName("yiijmgtyrocvmnvg")
    public suspend fun vpnAuthenticationTypes(
        vararg
        values: Output<Either<String, VpnAuthenticationType>>,
    ) {
        this.vpnAuthenticationTypes = Output.all(values.asList())
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("cesvpsoarswovlyt")
    public suspend
    fun vpnAuthenticationTypes(values: List<Output<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = Output.all(values)
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("mhgcogmufyoqabqv")
    public suspend fun vpnClientAddressPool(`value`: Output<AddressSpaceArgs>) {
        this.vpnClientAddressPool = value
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("gsfmfbwnvqkndrfg")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("vewthyjdjacgficl")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("kvowomenbmpvgmhg")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("kpmoggafiegxjyma")
    public suspend fun vpnClientProtocols(`value`: Output<List<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = value
    }

    @JvmName("lvtrcoltnpuednrk")
    public suspend fun vpnClientProtocols(vararg values: Output<Either<String, VpnClientProtocol>>) {
        this.vpnClientProtocols = Output.all(values.asList())
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("hkltheeadvounerg")
    public suspend fun vpnClientProtocols(values: List<Output<Either<String, VpnClientProtocol>>>) {
        this.vpnClientProtocols = Output.all(values)
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("rbvqcpwpfsmceiip")
    public suspend
    fun vpnClientRevokedCertificates(`value`: Output<List<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = value
    }

    @JvmName("grqpfoovsevyhuln")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        values: Output<VpnClientRevokedCertificateArgs>,
    ) {
        this.vpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("elxsffhlqapgrhrf")
    public suspend
    fun vpnClientRevokedCertificates(values: List<Output<VpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("gsebmvdvmujbyaqo")
    public suspend
    fun vpnClientRootCertificates(`value`: Output<List<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = value
    }

    @JvmName("jioenykydibbjbyo")
    public suspend fun vpnClientRootCertificates(
        vararg
        values: Output<VpnClientRootCertificateArgs>,
    ) {
        this.vpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("aehhsrtrkwuldvxa")
    public suspend fun vpnClientRootCertificates(values: List<Output<VpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The AADAudience property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("llthncimrqmuwbtl")
    public suspend fun aadAudience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAudience = mapped
    }

    /**
     * @param value The AADIssuer property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("wbhnihgvwtmjsxgq")
    public suspend fun aadIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadIssuer = mapped
    }

    /**
     * @param value The AADTenant property of the VirtualNetworkGateway resource for vpn client connection used for AAD authentication.
     */
    @JvmName("mwxvivonedancguw")
    public suspend fun aadTenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenant = mapped
    }

    /**
     * @param value The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("pdcfdwnyxvxoowni")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
     */
    @JvmName("hsulhwesqvnsanyb")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value The radiusServers property for multiple radius server configuration.
     */
    @JvmName("vejhgwgnlkaxignc")
    public suspend fun radiusServers(`value`: List<RadiusServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("jgiknwrdivmcyacx")
    public suspend fun radiusServers(argument: List<suspend RadiusServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("vnylpmiceupxdbvr")
    public suspend fun radiusServers(vararg argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument The radiusServers property for multiple radius server configuration.
     */
    @JvmName("sapkqewrifqukdtw")
    public suspend fun radiusServers(argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RadiusServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param values The radiusServers property for multiple radius server configuration.
     */
    @JvmName("ghvnclcpnmlbcaoe")
    public suspend fun radiusServers(vararg values: RadiusServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("lxcrgkbjgjarkvrk")
    public suspend
    fun vngClientConnectionConfigurations(`value`: List<VngClientConnectionConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("vvnmslagakhsrxed")
    public suspend
    fun vngClientConnectionConfigurations(argument: List<suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("snpjbdxhlvjwofru")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VngClientConnectionConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param argument per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("pgdolwtcsqhejyyq")
    public suspend
    fun vngClientConnectionConfigurations(argument: suspend VngClientConnectionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VngClientConnectionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param values per ip address pool connection policy for virtual network gateway P2S client.
     */
    @JvmName("kteydgsadfaivigv")
    public suspend fun vngClientConnectionConfigurations(
        vararg
        values: VngClientConnectionConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vngClientConnectionConfigurations = mapped
    }

    /**
     * @param value VPN authentication types for the virtual network gateway..
     */
    @JvmName("efsbajvqjuclwkoa")
    public suspend fun vpnAuthenticationTypes(`value`: List<Either<String, VpnAuthenticationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param values VPN authentication types for the virtual network gateway..
     */
    @JvmName("sbcfbrowlsdajfph")
    public suspend fun vpnAuthenticationTypes(vararg values: Either<String, VpnAuthenticationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param value The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("vsxdguhdjxnggonx")
    public suspend fun vpnClientAddressPool(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents Address space for P2S VpnClient.
     */
    @JvmName("modlxwvgvipmuipt")
    public suspend fun vpnClientAddressPool(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientAddressPool = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("btlxxndhdkdxcjxg")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("slrvantivpgndmmw")
    public suspend
    fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("bnoabcaoheeripmx")
    public suspend fun vpnClientIpsecPolicies(
        vararg
        argument: suspend IpsecPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("ojpdfavlusyvwfbl")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for virtual network gateway P2S client.
     */
    @JvmName("lihppkrkcdflddrv")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("abdipkurrgewrsft")
    public suspend fun vpnClientProtocols(`value`: List<Either<String, VpnClientProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param values VpnClientProtocols for Virtual network gateway.
     */
    @JvmName("morjjqrcacufkkwb")
    public suspend fun vpnClientProtocols(vararg values: Either<String, VpnClientProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientProtocols = mapped
    }

    /**
     * @param value VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("njblsbxphvwdqmyh")
    public suspend fun vpnClientRevokedCertificates(`value`: List<VpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("oqmidietmdjviihk")
    public suspend
    fun vpnClientRevokedCertificates(argument: List<suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("kxkheeicbmpfxjkr")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("hnmerimxnbywfbam")
    public suspend
    fun vpnClientRevokedCertificates(argument: suspend VpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRevokedCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VpnClientRevokedCertificate for Virtual network gateway.
     */
    @JvmName("cbsgreptdavhaqth")
    public suspend fun vpnClientRevokedCertificates(vararg values: VpnClientRevokedCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("ruimlpcoqkrtfakf")
    public suspend fun vpnClientRootCertificates(`value`: List<VpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("qehfkpeofetebuqo")
    public suspend
    fun vpnClientRootCertificates(argument: List<suspend VpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("pwstxovhhkfuelff")
    public suspend fun vpnClientRootCertificates(
        vararg
        argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnClientRootCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("ryaemxpewgjokteb")
    public suspend
    fun vpnClientRootCertificates(argument: suspend VpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param values VpnClientRootCertificate for virtual network gateway.
     */
    @JvmName("qdalucqqubfuvvip")
    public suspend fun vpnClientRootCertificates(vararg values: VpnClientRootCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    internal fun build(): VpnClientConfigurationArgs = VpnClientConfigurationArgs(
        aadAudience = aadAudience,
        aadIssuer = aadIssuer,
        aadTenant = aadTenant,
        radiusServerAddress = radiusServerAddress,
        radiusServerSecret = radiusServerSecret,
        radiusServers = radiusServers,
        vngClientConnectionConfigurations = vngClientConnectionConfigurations,
        vpnAuthenticationTypes = vpnAuthenticationTypes,
        vpnClientAddressPool = vpnClientAddressPool,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnClientProtocols = vpnClientProtocols,
        vpnClientRevokedCertificates = vpnClientRevokedCertificates,
        vpnClientRootCertificates = vpnClientRootCertificates,
    )
}
