@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnLinkBgpSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * BGP settings details for a link.
 * @property asn The BGP speaker's ASN.
 * @property bgpPeeringAddress The BGP peering address and BGP identifier of this BGP speaker.
 */
public data class VpnLinkBgpSettingsArgs(
    public val asn: Output<Double>? = null,
    public val bgpPeeringAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnLinkBgpSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnLinkBgpSettingsArgs =
        com.pulumi.azurenative.network.inputs.VpnLinkBgpSettingsArgs.builder()
            .asn(asn?.applyValue({ args0 -> args0 }))
            .bgpPeeringAddress(bgpPeeringAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnLinkBgpSettingsArgs].
 */
@PulumiTagMarker
public class VpnLinkBgpSettingsArgsBuilder internal constructor() {
    private var asn: Output<Double>? = null

    private var bgpPeeringAddress: Output<String>? = null

    /**
     * @param value The BGP speaker's ASN.
     */
    @JvmName("qgxoujuoawfndtob")
    public suspend fun asn(`value`: Output<Double>) {
        this.asn = value
    }

    /**
     * @param value The BGP peering address and BGP identifier of this BGP speaker.
     */
    @JvmName("hkbbftaxwidhpvll")
    public suspend fun bgpPeeringAddress(`value`: Output<String>) {
        this.bgpPeeringAddress = value
    }

    /**
     * @param value The BGP speaker's ASN.
     */
    @JvmName("ndnjstdvdwndmvut")
    public suspend fun asn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asn = mapped
    }

    /**
     * @param value The BGP peering address and BGP identifier of this BGP speaker.
     */
    @JvmName("xvhpdmqmaqxwobbl")
    public suspend fun bgpPeeringAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeeringAddress = mapped
    }

    internal fun build(): VpnLinkBgpSettingsArgs = VpnLinkBgpSettingsArgs(
        asn = asn,
        bgpPeeringAddress = bgpPeeringAddress,
    )
}
