@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VpnServerConfigurationPolicyGroup Resource.
 * @property id Resource ID.
 * @property isDefault Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property policyMembers Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
 * @property priority Priority for VpnServerConfigurationPolicyGroup.
 */
public data class VpnServerConfigurationPolicyGroupArgs(
    public val id: Output<String>? = null,
    public val isDefault: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val policyMembers: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>? = null,
    public val priority: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupArgs =
        com.pulumi.azurenative.network.inputs.VpnServerConfigurationPolicyGroupArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .isDefault(isDefault?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .policyMembers(
                policyMembers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .priority(priority?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigurationPolicyGroupArgs].
 */
@PulumiTagMarker
public class VpnServerConfigurationPolicyGroupArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var isDefault: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var policyMembers: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("ksxichcusqfjgmsr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    @JvmName("iblnphlgxmtpqsbl")
    public suspend fun isDefault(`value`: Output<Boolean>) {
        this.isDefault = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cwsulrwtbyresdur")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("pakfpqfixkxqruoc")
    public suspend
    fun policyMembers(`value`: Output<List<VpnServerConfigurationPolicyGroupMemberArgs>>) {
        this.policyMembers = value
    }

    @JvmName("frqexgtqrwcjvijk")
    public suspend fun policyMembers(
        vararg
        values: Output<VpnServerConfigurationPolicyGroupMemberArgs>,
    ) {
        this.policyMembers = Output.all(values.asList())
    }

    /**
     * @param values Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("hyaebrrotsvsxgjg")
    public suspend
    fun policyMembers(values: List<Output<VpnServerConfigurationPolicyGroupMemberArgs>>) {
        this.policyMembers = Output.all(values)
    }

    /**
     * @param value Priority for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("wuntyveyhoeubeqq")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pxatqukumohlbfcp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    @JvmName("suqaytjanystqhxi")
    public suspend fun isDefault(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefault = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("hvhsenblcmiinavb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("ungqaxsvblyvjelt")
    public suspend fun policyMembers(`value`: List<VpnServerConfigurationPolicyGroupMemberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("bcheedcfecjaahkl")
    public suspend
    fun policyMembers(argument: List<suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("skrhhmkfxkdbgkbc")
    public suspend fun policyMembers(
        vararg
        argument: suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param argument Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("rwertcbccdcytuhm")
    public suspend
    fun policyMembers(argument: suspend VpnServerConfigurationPolicyGroupMemberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigurationPolicyGroupMemberArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyMembers = mapped
    }

    /**
     * @param values Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("fcnmgbpecfteqfwh")
    public suspend fun policyMembers(vararg values: VpnServerConfigurationPolicyGroupMemberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyMembers = mapped
    }

    /**
     * @param value Priority for VpnServerConfigurationPolicyGroup.
     */
    @JvmName("pusihbxybmjmnbtt")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): VpnServerConfigurationPolicyGroupArgs =
        VpnServerConfigurationPolicyGroupArgs(
            id = id,
            isDefault = isDefault,
            name = name,
            policyMembers = policyMembers,
            priority = priority,
        )
}
