@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
 * @property addressPrefixes A list of address blocks reserved for this virtual network in CIDR notation.
 */
public data class AddressSpaceResponse(
    public val addressPrefixes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AddressSpaceResponse):
            AddressSpaceResponse = AddressSpaceResponse(
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
        )
    }
}
