@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Application Gateway autoscale configuration.
 * @property maxCapacity Upper bound on number of Application Gateway capacity.
 * @property minCapacity Lower bound on number of Application Gateway capacity.
 */
public data class ApplicationGatewayAutoscaleConfigurationResponse(
    public val maxCapacity: Int? = null,
    public val minCapacity: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayAutoscaleConfigurationResponse):
            ApplicationGatewayAutoscaleConfigurationResponse =
            ApplicationGatewayAutoscaleConfigurationResponse(
                maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
                minCapacity = javaType.minCapacity(),
            )
    }
}
