@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Frontend IP configuration of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the frontend IP configuration that is unique within an Application Gateway.
 * @property privateIPAddress PrivateIPAddress of the network interface IP Configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property privateLinkConfiguration Reference to the application gateway private link configuration.
 * @property provisioningState The provisioning state of the frontend IP configuration resource.
 * @property publicIPAddress Reference to the PublicIP resource.
 * @property subnet Reference to the subnet resource.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayFrontendIPConfigurationResponse(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val privateLinkConfiguration: SubResourceResponse? = null,
    public val provisioningState: String,
    public val publicIPAddress: SubResourceResponse? = null,
    public val subnet: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayFrontendIPConfigurationResponse):
            ApplicationGatewayFrontendIPConfigurationResponse =
            ApplicationGatewayFrontendIPConfigurationResponse(
                etag = javaType.etag(),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
                privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                    args0
                }).orElse(null),
                privateLinkConfiguration = javaType.privateLinkConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                subnet = javaType.subnet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
