@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Header configuration of the Actions set in Application Gateway.
 * @property headerName Header name of the header configuration.
 * @property headerValue Header value of the header configuration.
 */
public data class ApplicationGatewayHeaderConfigurationResponse(
    public val headerName: String? = null,
    public val headerValue: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayHeaderConfigurationResponse):
            ApplicationGatewayHeaderConfigurationResponse =
            ApplicationGatewayHeaderConfigurationResponse(
                headerName = javaType.headerName().map({ args0 -> args0 }).orElse(null),
                headerValue = javaType.headerValue().map({ args0 -> args0 }).orElse(null),
            )
    }
}
