@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Http listener of an application gateway.
 * @property customErrorConfigurations Custom error configurations of the HTTP listener.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property firewallPolicy Reference to the FirewallPolicy resource.
 * @property frontendIPConfiguration Frontend IP configuration resource of an application gateway.
 * @property frontendPort Frontend port resource of an application gateway.
 * @property hostName Host name of HTTP listener.
 * @property hostNames List of Host names for HTTP Listener that allows special wildcard characters as well.
 * @property id Resource ID.
 * @property name Name of the HTTP listener that is unique within an Application Gateway.
 * @property protocol Protocol of the HTTP listener.
 * @property provisioningState The provisioning state of the HTTP listener resource.
 * @property requireServerNameIndication Applicable only if protocol is https. Enables SNI for multi-hosting.
 * @property sslCertificate SSL certificate resource of an application gateway.
 * @property sslProfile SSL profile resource of the application gateway.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayHttpListenerResponse(
    public val customErrorConfigurations: List<ApplicationGatewayCustomErrorResponse>? = null,
    public val etag: String,
    public val firewallPolicy: SubResourceResponse? = null,
    public val frontendIPConfiguration: SubResourceResponse? = null,
    public val frontendPort: SubResourceResponse? = null,
    public val hostName: String? = null,
    public val hostNames: List<String>? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val requireServerNameIndication: Boolean? = null,
    public val sslCertificate: SubResourceResponse? = null,
    public val sslProfile: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayHttpListenerResponse):
            ApplicationGatewayHttpListenerResponse = ApplicationGatewayHttpListenerResponse(
            customErrorConfigurations = javaType.customErrorConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayCustomErrorResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            firewallPolicy = javaType.firewallPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendIPConfiguration = javaType.frontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            hostNames = javaType.hostNames().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            requireServerNameIndication = javaType.requireServerNameIndication().map({ args0 ->
                args0
            }).orElse(null),
            sslCertificate = javaType.sslCertificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sslProfile = javaType.sslProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
