@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Listener of an application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property frontendIPConfiguration Frontend IP configuration resource of an application gateway.
 * @property frontendPort Frontend port resource of an application gateway.
 * @property id Resource ID.
 * @property name Name of the listener that is unique within an Application Gateway.
 * @property protocol Protocol of the listener.
 * @property provisioningState The provisioning state of the listener resource.
 * @property sslCertificate SSL certificate resource of an application gateway.
 * @property sslProfile SSL profile resource of the application gateway.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayListenerResponse(
    public val etag: String,
    public val frontendIPConfiguration: SubResourceResponse? = null,
    public val frontendPort: SubResourceResponse? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val sslCertificate: SubResourceResponse? = null,
    public val sslProfile: SubResourceResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayListenerResponse):
            ApplicationGatewayListenerResponse = ApplicationGatewayListenerResponse(
            etag = javaType.etag(),
            frontendIPConfiguration = javaType.frontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sslCertificate = javaType.sslCertificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sslProfile = javaType.sslProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
